/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.nessaccessor.tcp;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.nessaccessor.tcp.ReflowService;
import io.intino.alexandria.zim.ZimReader;
import io.intino.alexandria.zim.ZimStream;
import io.intino.ness.core.Datalake;
import io.intino.ness.core.fs.FS;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Predicate;

public class TCPEventTank
implements Datalake.EventStore.Tank {
    private final String name;
    private final ReflowService service;

    TCPEventTank(String name, ReflowService service) {
        this.name = name;
        this.service = service;
    }

    public String name() {
        return this.name;
    }

    public ZimStream content() {
        return ZimStream.Sequence.of((ZimStream[])this.zimStreams(t -> true));
    }

    public ZimStream content(Predicate<Timetag> filter) {
        return ZimStream.Sequence.of((ZimStream[])this.zimStreams(filter));
    }

    private ZimStream[] zimStreams(Predicate<Timetag> filter) {
        String root = this.service.request("quickReflow");
        File directory = this.directory(root);
        if (!directory.exists()) {
            return new ZimStream[0];
        }
        return (ZimStream[])FS.allFilesIn((File)directory, f -> f.getName().endsWith(".zim")).sorted().filter(f -> filter.test(this.timetagOf((File)f))).map(ZimReader::new).toArray(ZimStream[]::new);
    }

    private File directory(String value) {
        try {
            return new File(new File(new URI(value)), this.name);
        }
        catch (URISyntaxException e) {
            return new File(value);
        }
    }

    private Timetag timetagOf(File file) {
        return new Timetag(file.getName().replace(".zim", ""));
    }
}

