/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.nessaccessor.tcp;

import io.intino.alexandria.jms.Consumer;
import io.intino.alexandria.jms.MessageFactory;
import io.intino.alexandria.jms.TopicProducer;
import io.intino.alexandria.logger.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;

public abstract class Service {
    protected final Session session;

    public Service(Session session) {
        this.session = session;
    }

    String request(String query) {
        return this.request(query, 1000L);
    }

    String request(String query, long timeout) {
        try {
            TopicProducer producer = this.newProducer();
            if (producer == null) {
                return "";
            }
            Message message = MessageFactory.createMessageFor((Object)query);
            message.setJMSReplyTo((Destination)this.session.createTemporaryQueue());
            producer.produce(message);
            Message response = this.session.createConsumer(message.getJMSReplyTo()).receive(timeout);
            return response == null ? "" : Consumer.textFrom((Message)response);
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }

    void send(String message) {
        TopicProducer producer = this.newProducer();
        if (producer == null) {
            return;
        }
        producer.produce(MessageFactory.createMessageFor((Object)message));
        producer.close();
    }

    protected abstract TopicProducer newProducer();
}

