/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.nessaccessor.stages;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.nessaccessor.Stage;
import io.intino.ness.core.Blob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class MemoryStage
implements Stage {
    private List<MemoryOutputStream> streams = new ArrayList<MemoryOutputStream>();

    @Override
    public OutputStream start(Blob.Type type) {
        return this.start("", type);
    }

    @Override
    public OutputStream start(String prefix, Blob.Type type) {
        try {
            this.streams.add(0, new MemoryOutputStream(this.name(prefix), type));
            return this.streams.get(0);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    @Override
    public Stream<Blob> blobs() {
        return this.streams.stream().map(s -> new Blob((MemoryOutputStream)s){
            final /* synthetic */ MemoryOutputStream val$s;
            {
                this.val$s = memoryOutputStream;
            }

            public String name() {
                return this.val$s.name();
            }

            public Blob.Type type() {
                return this.val$s.type();
            }

            public InputStream inputStream() {
                return new ByteArrayInputStream(this.val$s.toByteArray());
            }
        });
    }

    @Override
    public void clear() {
        this.streams.clear();
    }

    private class MemoryOutputStream
    extends ByteArrayOutputStream {
        private final String name;
        private final Blob.Type type;

        public MemoryOutputStream(String name, Blob.Type type) throws IOException {
            this.name = name;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public Blob.Type type() {
            return this.type;
        }
    }
}

