/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.Parser;
import java.lang.reflect.Array;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ParserFactory {
    private static final Map<Class<?>, Parser> Parsers = new HashMap();

    ParserFactory() {
    }

    private static void primitives() {
        ParserFactory.register(Boolean.TYPE, Boolean::parseBoolean);
        ParserFactory.register(Byte.TYPE, Byte::parseByte);
        ParserFactory.register(Character.TYPE, s -> Character.valueOf((char)Integer.parseInt(s)));
        ParserFactory.register(Short.TYPE, Short::parseShort);
        ParserFactory.register(Integer.TYPE, Integer::parseInt);
        ParserFactory.register(Long.TYPE, Long::parseLong);
        ParserFactory.register(Float.TYPE, Float::parseFloat);
        ParserFactory.register(Double.TYPE, Double::parseDouble);
    }

    private static void boxed() {
        ParserFactory.register(Boolean.class, Parsers.get(Boolean.TYPE));
        ParserFactory.register(Byte.class, Parsers.get(Byte.TYPE));
        ParserFactory.register(Character.class, Parsers.get(Character.TYPE));
        ParserFactory.register(Short.class, Parsers.get(Short.TYPE));
        ParserFactory.register(Integer.class, Parsers.get(Integer.TYPE));
        ParserFactory.register(Long.class, Parsers.get(Long.TYPE));
        ParserFactory.register(Float.class, Parsers.get(Float.TYPE));
        ParserFactory.register(Double.class, Parsers.get(Double.TYPE));
        ParserFactory.register(Number.class, ParserFactory::parseNumber);
    }

    private static void text() {
        ParserFactory.register(String.class, text -> text);
        ParserFactory.register(CharSequence.class, text -> text);
    }

    private static void datetime() {
        ParserFactory.register(Instant.class, Instant::parse);
        ParserFactory.register(LocalTime.class, LocalTime::parse);
        ParserFactory.register(LocalDate.class, LocalDate::parse);
        ParserFactory.register(LocalDateTime.class, LocalDateTime::parse);
    }

    static boolean contains(Class<?> type) {
        return Parsers.containsKey(type);
    }

    static Parser get(Class<?> type) {
        if (!ParserFactory.contains(type)) {
            throw new NoSuchParserException("No parser found for type " + type);
        }
        return Parsers.get(type);
    }

    private static void register(Class<?> clazz, Parser parser) {
        Parsers.put(clazz, ParserFactory.safe(clazz, parser));
        if (!clazz.isArray()) {
            ParserFactory.registerArrayOf(clazz);
        }
    }

    private static void registerArrayOf(Class<?> clazz) {
        ParserFactory.register(Array.newInstance(clazz, 0).getClass(), ArrayParser.of(clazz));
    }

    private static Number parseNumber(String str) {
        Number[] result = new Number[1];
        for (Class<Double> numberType : List.of(Long.class, Double.class)) {
            if (!ParserFactory.tryParseNumber(numberType, str, result)) continue;
            return result[0];
        }
        throw new NumberFormatException(str);
    }

    private static boolean tryParseNumber(Class<?> numberType, String str, Number[] result) {
        try {
            result[0] = (Number)ParserFactory.get(numberType).parse(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Parser safe(Class<?> targetType, Parser parser) {
        return textToParse -> {
            try {
                return textToParse == null || "\u0000".equals(textToParse) ? null : parser.parse(textToParse);
            }
            catch (Exception e) {
                throw new Parser.ParseException("Could not parse " + textToParse + " to " + targetType + ": " + e.getMessage(), e);
            }
        };
    }

    static <T> Class<T[]> arrayTypeOf(Class<?> elementType) {
        return Array.newInstance(elementType, 0).getClass();
    }

    static {
        ParserFactory.primitives();
        ParserFactory.boxed();
        ParserFactory.text();
        ParserFactory.datetime();
    }

    private static class NoSuchParserException
    extends RuntimeException {
        public NoSuchParserException(String message) {
            super(message);
        }
    }

    private static class ArrayParser
    implements Parser {
        private final Class<?> elementType;

        private ArrayParser(Class<?> elementType) {
            this.elementType = elementType;
        }

        @Override
        public Object parse(String text) {
            Parser parser = Parser.of(this.elementType);
            String[] items = text.split(Message.ListSepStr);
            Object result = Array.newInstance(this.elementType, items.length);
            for (int i = 0; i < items.length; ++i) {
                String item = items[i];
                Array.set(result, i, "\u0000".equals(item) ? null : parser.parse(item));
            }
            return result;
        }

        private static ArrayParser of(Class<?> type) {
            return new ArrayParser(type);
        }
    }
}

