/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageException;
import io.intino.alexandria.message.MessageStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class MessageReader
implements Iterator<Message>,
Iterable<Message>,
AutoCloseable {
    private final MessageStream messageStream;
    private final Message[] contextList;
    private final String[] lines;
    private int numLines;

    public MessageReader(String str) {
        this(new ByteArrayInputStream(str.getBytes()), new Config());
    }

    public MessageReader(String str, Config config) {
        this(new ByteArrayInputStream(str.getBytes()), config);
    }

    public MessageReader(InputStream inputStream) {
        this(new MessageStream(inputStream), new Config());
    }

    public MessageReader(InputStream inputStream, Config config) {
        this(new MessageStream(inputStream), config);
    }

    public MessageReader(MessageStream messageStream) {
        this(messageStream, new Config());
    }

    public MessageReader(MessageStream messageStream, Config config) {
        this.messageStream = messageStream;
        this.lines = new String[Math.max(config.linesBufferSize, 1)];
        this.contextList = new Message[Math.max(config.contextMaxLevels, 1)];
        this.init();
    }

    @Override
    public boolean hasNext() {
        return this.numLines > 0;
    }

    @Override
    public Message next() {
        try {
            return this.hasNext() ? this.nextMessage() : null;
        }
        catch (MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public Iterator<Message> iterator() {
        return this;
    }

    @Override
    public void close() throws Exception {
        try {
            this.messageStream.close();
        }
        catch (IOException e) {
            Logger.getGlobal().severe(e.getMessage());
        }
    }

    private Message nextMessage() {
        this.parse(this.lines, this.numLines, this.contextList);
        while ((this.numLines = this.messageStream.nextLines(this.lines)) > 0 && this.isComponent(this.lines[0])) {
            this.parse(this.lines, this.numLines, this.contextList);
        }
        return this.firstNonNullAndReset(this.contextList);
    }

    private void parse(String[] lines, int size, Message[] contextList) {
        String type = this.typeOf(lines[0]);
        lines[0] = null;
        String[] context = type.split("\\.", -1);
        int level = context.length - 1;
        Message message = new Message(context[level]);
        if (level > 0 && contextList[level - 1] != null) {
            contextList[level - 1].add(message);
        }
        contextList[level] = message;
        this.readAttributes(message, lines, size);
    }

    private void readAttributes(Message message, String[] lines, int size) {
        for (int i = 1; i < size; ++i) {
            String line = lines[i];
            lines[i] = null;
            try {
                int attribSep = line.indexOf(58);
                if (attribSep < 0) continue;
                message.setUnsafe(this.nameOf(line, attribSep), this.valueOf(line, attribSep));
                continue;
            }
            catch (Exception e) {
                throw new MessageException("Malformed message attribute at line " + i + ": " + line, e);
            }
        }
    }

    private String valueOf(String line, int attribSep) {
        int start = line.indexOf(32, attribSep + 1);
        return line.substring(start < 0 ? attribSep + 1 : start + 1);
    }

    private String nameOf(String line, int attribSep) {
        return line.substring(0, attribSep);
    }

    private String typeOf(String line) {
        return line.substring(1, line.lastIndexOf(93));
    }

    private boolean isComponent(String next) {
        return next.indexOf(46) > 0;
    }

    private Message firstNonNullAndReset(Message[] messages) {
        Message message = null;
        for (int i = 0; i < messages.length; ++i) {
            Message m = messages[i];
            if (m != null && message == null) {
                message = m;
            }
            messages[i] = null;
        }
        if (message == null) {
            throw new NoSuchElementException("No messages left");
        }
        return message;
    }

    private void init() {
        if (this.messageStream.hasNext()) {
            this.numLines = this.messageStream.nextLines(this.lines);
        }
    }

    public static class Config {
        private int linesBufferSize = 128;
        private int contextMaxLevels = 8;

        public Config linesBufferSize(int linesBufferSize) {
            this.linesBufferSize = linesBufferSize;
            return this;
        }

        public Config contextMaxLevels(int contextMaxLevels) {
            this.contextMaxLevels = contextMaxLevels;
            return this;
        }
    }
}

