/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.markov;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Markov {
    private final int size;
    private final String[] states;
    private final Map<String, Integer> map;
    private final int[][] count;
    private Type type;
    private static final int Threshold = 65536;

    public Markov(String ... states) {
        this(states, new int[states.length][states.length]);
    }

    private Markov(String[] states, int[][] count) {
        this.size = states.length;
        this.states = states;
        this.map = Markov.asMap(states);
        this.count = count;
        this.type = Type.Directed;
    }

    public Markov set(Type type) {
        this.type = type;
        return this;
    }

    public String[] states() {
        return this.states;
    }

    public int[][] transitions() {
        return this.count;
    }

    public double[][] transitionProbabilities() {
        double[][] result = new double[this.size][];
        for (int row = 0; row < this.size; ++row) {
            result[row] = this.transitionProbabilities(row);
        }
        return result;
    }

    private double[] transitionProbabilities(int row) {
        double[] result = new double[this.size];
        double sum = this.sum(row);
        for (int i = 0; i < this.size; ++i) {
            result[i] = sum > 0.0 ? (double)this.count[row][i] / sum : (i == row ? 1.0 : 0.0);
        }
        return result;
    }

    public double[] randomWalk(String from) {
        return this.power(this.transitionProbabilities())[this.map.get(from)];
    }

    private double[][] power(double[][] matrix) {
        double[][] result = matrix;
        for (int i = 1; i < 100; ++i) {
            result = this.multiply(result, matrix);
        }
        return result;
    }

    private double[][] multiply(double[][] a, double[][] b) {
        double[][] c = new double[this.size][this.size];
        IntStream.range(0, this.size).parallel().forEach(i -> {
            for (int k = 0; k < this.size; ++k) {
                for (int j = 0; j < this.size; ++j) {
                    double[] dArray = c[i];
                    int n = j;
                    dArray[n] = dArray[n] + a[i][k] * b[k][j];
                }
            }
        });
        return c;
    }

    public Markov add(String from, String to) {
        this.increment(from, to);
        if (this.type == Type.Undirected) {
            this.increment(to, from);
        }
        return this;
    }

    private void increment(String from, String to) {
        int row = this.map.get(from);
        int col = this.map.get(to);
        int[] nArray = this.count[row];
        int n = col;
        nArray[n] = nArray[n] + 1;
        if (nArray[n] >= 65536) {
            this.shrink(row);
        }
    }

    private int sum(int row) {
        return Arrays.stream(this.count[row]).sum();
    }

    private void shrink(int row) {
        int i = 0;
        while (i < this.size) {
            int[] nArray = this.count[row];
            int n = i++;
            nArray[n] = nArray[n] >> 1;
        }
    }

    private static Map<String, Integer> asMap(String[] states) {
        return IntStream.range(0, states.length).boxed().collect(Collectors.toMap(i -> states[i], i -> i));
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            sb.append('|').append(this.states[i]).append(':').append(this.serialize(this.count[i]));
        }
        return sb.substring(1);
    }

    private String serialize(int[] count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            sb.append(',').append(count[i]);
        }
        return sb.substring(1);
    }

    public static Markov deserialize(String line) {
        return Markov.deserialize(line.split("\\|"));
    }

    private static Markov deserialize(String[] lines) {
        return Markov.deserialize(Arrays.stream(lines).filter(l -> !l.isEmpty()).map(Markov::parse).collect(Collectors.toList()));
    }

    private static Markov deserialize(List<String[]> data) {
        return new Markov(Markov.statesIn(data), Markov.countIn(data));
    }

    private static String[] statesIn(List<String[]> data) {
        return (String[])data.stream().map(l -> l[0]).toArray(String[]::new);
    }

    private static int[][] countIn(List<String[]> data) {
        return (int[][])data.stream().map(Markov::parse).toArray(x$0 -> new int[x$0][]);
    }

    private static String[] parse(String line) {
        return line.split("[:,]");
    }

    private static int[] parse(String[] data) {
        return Arrays.stream(data).skip(1L).mapToInt(Integer::parseInt).toArray();
    }

    public static enum Type {
        Directed,
        Undirected;

    }
}

