/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.memory;

import io.intino.alexandria.led.util.memory.AllocationInfo;
import java.util.List;

public interface NativeMemoryTracker {
    public List<AllocationInfo> getLiveAllocations();

    public int numLiveAllocations();

    public long totalAllocationSize();

    default public float totalAllocationSizeMB() {
        return (float)this.totalAllocationSize() / 1024.0f / 1024.0f;
    }

    default public AllocationInfo find(long address) {
        return this.getLiveAllocations().stream().filter(allocationInfo -> allocationInfo.address().get() == address).findAny().orElse(null);
    }
}

