/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.memory;

import io.intino.alexandria.led.util.memory.MemoryAddress;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ModifiableMemoryAddress
implements MemoryAddress {
    private long address;

    public ModifiableMemoryAddress(long address) {
        this.address = address;
    }

    @Override
    public long get() {
        return this.address;
    }

    public void set(long address) {
        this.address = address;
    }

    @Override
    public boolean isNull() {
        return this.address == 0L;
    }

    @Override
    public boolean notNull() {
        return this.address != 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemoryAddress)) {
            return false;
        }
        MemoryAddress that = (MemoryAddress)o;
        return this.address == that.get();
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public static ModifiableMemoryAddress of(ByteBuffer buffer) {
        return new ModifiableMemoryAddress(MemoryUtils.addressOf(buffer));
    }
}

