/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.memory;

import io.intino.alexandria.led.util.memory.MemoryUtils;
import java.nio.ByteBuffer;

public interface MemoryAddress {
    public static MemoryAddress of(final ByteBuffer buffer) {
        return new MemoryAddress(){
            private final long address;
            {
                this.address = MemoryUtils.addressOf(buffer);
            }

            @Override
            public long get() {
                return this.address;
            }
        };
    }

    public long get();

    default public boolean isNull() {
        return this.get() == 0L;
    }

    default public boolean notNull() {
        return this.get() != 0L;
    }
}

