/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.collections;

import io.intino.alexandria.led.util.collections.LongList;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public class SparseLongList
implements LongList {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final int DEFAULT_ARRAY_SIZE = 1024;
    private static final float DEFAULT_GROW_FACTOR = 2.0f;
    private long[][] arrays;
    private final int arraySize;
    private int arrayIndex;
    private int relativeIndex;
    private float growFactor;

    public SparseLongList() {
        this(10, 1024, 2.0f);
    }

    public SparseLongList(int initialCapacity, int arraySize, float growFactor) {
        this.arrays = new long[initialCapacity][];
        this.arrays[0] = new long[arraySize];
        this.arraySize = arraySize;
        this.growFactor(growFactor);
    }

    @Override
    public int size() {
        return this.arrayIndex * this.arraySize + this.relativeIndex;
    }

    @Override
    public int capacity() {
        return this.arrays.length * this.arraySize;
    }

    @Override
    public float growFactor() {
        return this.growFactor;
    }

    @Override
    public void growFactor(float growFactor) {
        if (growFactor <= 1.0f) {
            throw new IllegalArgumentException("Grow factor must be > 0");
        }
        this.growFactor = growFactor;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(long o) {
        return this.parallelStream().anyMatch(e -> e == o);
    }

    @Override
    public Iterator<Long> iterator() {
        return new SparseLongListIterator();
    }

    @Override
    public void add(long element) {
        if (this.relativeIndex >= this.arraySize) {
            if (++this.arrayIndex >= this.arrays.length) {
                this.grow();
            }
            this.arrays[this.arrayIndex] = new long[this.arraySize];
            this.relativeIndex = 0;
        }
        this.arrays[this.arrayIndex][this.relativeIndex++] = element;
    }

    private void grow() {
        long newCapacity = (long)Math.ceil((float)this.capacity() * this.growFactor);
        if (newCapacity > Integer.MAX_VALUE) {
            throw new OutOfMemoryError();
        }
        this.grow((int)newCapacity);
    }

    private void grow(int newCapacity) {
        this.arrays = (long[][])Arrays.copyOf(this.arrays, newCapacity);
    }

    @Override
    public boolean containsAll(Iterable<Long> c) {
        int i = 0;
        for (Long element : c) {
            if (element == null) {
                return false;
            }
            if (element.longValue() == this.get(i++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addAll(Iterable<Long> c) {
        c.forEach(this::add);
    }

    @Override
    public void clear() {
        this.relativeIndex = 0;
        this.arrayIndex = 0;
    }

    @Override
    public long get(int index) {
        int arrayIndex = index / this.arraySize;
        int relativeIndex = index % this.arraySize;
        return this.arrays[arrayIndex][relativeIndex];
    }

    public long get(int arrayIndex, int relativeIndex) {
        return this.arrays[arrayIndex][relativeIndex];
    }

    @Override
    public long set(int index, long element) {
        int arrayIndex = index / this.arraySize;
        int relativeIndex = index % this.arraySize;
        long oldValue = this.arrays[arrayIndex][relativeIndex];
        this.arrays[arrayIndex][relativeIndex] = element;
        return oldValue;
    }

    @Override
    public LongStream stream() {
        return IntStream.range(0, this.size()).mapToLong(this::get);
    }

    @Override
    public LongStream parallelStream() {
        return this.stream().parallel();
    }

    @Override
    public List<Long> asList() {
        return new AbstractList<Long>(){

            @Override
            public Long get(int index) {
                return SparseLongList.this.get(index);
            }

            @Override
            public int size() {
                return SparseLongList.this.size();
            }
        };
    }

    private class SparseLongListIterator
    implements Iterator<Long> {
        private int iteratorArrayIndex;
        private int iteratorRelativeIndex;

        private SparseLongListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iteratorArrayIndex * SparseLongList.this.arraySize + this.iteratorRelativeIndex < SparseLongList.this.size();
        }

        @Override
        public Long next() {
            if (this.iteratorRelativeIndex >= SparseLongList.this.arraySize) {
                ++this.iteratorArrayIndex;
                this.iteratorRelativeIndex = 0;
            }
            return SparseLongList.this.get(this.iteratorArrayIndex, this.iteratorRelativeIndex++);
        }
    }
}

