/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.collections;

import io.intino.alexandria.led.util.collections.LongList;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public class ArrayLongList
implements LongList {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final int DEFAULT_GROW_FACTOR = 2;
    private long[] data;
    private int size;
    private float growFactor;

    public ArrayLongList() {
        this(10, 2.0f);
    }

    public ArrayLongList(int initialCapacity, float growFactor) {
        this.data = new long[initialCapacity];
        this.growFactor(growFactor);
    }

    public ArrayLongList(long[] data) {
        this(data.length, 2.0f);
        this.data = data;
        this.size = data.length;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return this.data.length;
    }

    public long[] data() {
        return this.data;
    }

    public void trimToSize() {
        if (this.size < this.data.length) {
            this.data = Arrays.copyOf(this.data, this.size);
        }
    }

    @Override
    public float growFactor() {
        return this.growFactor;
    }

    @Override
    public void growFactor(float growFactor) {
        if (growFactor <= 0.0f) {
            throw new IllegalArgumentException("Grow factor must be > 0");
        }
        this.growFactor = growFactor;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(long o) {
        return this.parallelStream().anyMatch(e -> e == o);
    }

    @Override
    public Iterator<Long> iterator() {
        return this.listIterator();
    }

    @Override
    public void add(long element) {
        if (this.size >= this.capacity()) {
            this.grow();
        }
        this.data[this.size++] = element;
    }

    private void grow() {
        long newCapacity = (long)Math.ceil((float)this.capacity() * this.growFactor);
        if (newCapacity > Integer.MAX_VALUE) {
            throw new OutOfMemoryError();
        }
        this.grow((int)newCapacity);
    }

    private void grow(int newCapacity) {
        this.data = Arrays.copyOf(this.data, newCapacity);
    }

    public boolean remove(long value) {
        int i;
        long[] data = this.data;
        int size = this.size;
        for (i = 0; i < size && data[i] != value; ++i) {
        }
        if (i == size) {
            return false;
        }
        this.fastRemove(data, i);
        return true;
    }

    private void fastRemove(long[] data, int indexToRemove) {
        if (--this.size > indexToRemove) {
            System.arraycopy(data, indexToRemove + 1, data, indexToRemove, this.size - indexToRemove);
        }
    }

    @Override
    public boolean containsAll(Iterable<Long> c) {
        int i = 0;
        for (Long element : c) {
            if (element == null) {
                return false;
            }
            if (element == this.data[i++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addAll(Iterable<Long> c) {
        if (c instanceof ArrayLongList) {
            ArrayLongList other = (ArrayLongList)c;
            if (this.size + other.size > this.capacity()) {
                this.grow(this.size + other.size);
            }
            System.arraycopy(other.data, 0, this.data, this.size, other.size);
            this.size += other.size;
        } else {
            c.forEach(this::add);
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public long get(int index) {
        return this.data[index];
    }

    @Override
    public long set(int index, long element) {
        long oldValue = this.data[index];
        this.data[index] = element;
        return oldValue;
    }

    public void add(int index, long element) {
        if (this.size >= this.capacity()) {
            this.grow();
        }
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = element;
        ++this.size;
    }

    public long remove(int index) {
        long oldValue = this.data[index];
        this.fastRemove(this.data, index);
        return oldValue;
    }

    public int indexOf(long valueToFind) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != valueToFind) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long valueToFind) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.data[i] != valueToFind) continue;
            return i;
        }
        return -1;
    }

    public int binarySearch(long value) {
        return 0;
    }

    public ListIterator<Long> listIterator() {
        return new JvmGrowableLongArrayListIterator(0);
    }

    public ListIterator<Long> listIterator(int index) {
        return new JvmGrowableLongArrayListIterator(index);
    }

    @Override
    public LongStream stream() {
        return IntStream.range(0, this.size).mapToLong(this::get);
    }

    @Override
    public LongStream parallelStream() {
        return this.stream().parallel();
    }

    @Override
    public List<Long> asList() {
        return new AbstractList<Long>(){

            @Override
            public Long get(int index) {
                return ArrayLongList.this.get(index);
            }

            @Override
            public int size() {
                return ArrayLongList.this.size;
            }
        };
    }

    public final class JvmGrowableLongArrayListIterator
    implements ListIterator<Long> {
        private int index;

        public JvmGrowableLongArrayListIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < ArrayLongList.this.size;
        }

        @Override
        public Long next() {
            return ArrayLongList.this.data[this.index++];
        }

        @Override
        public boolean hasPrevious() {
            return this.index - 1 >= 0;
        }

        @Override
        public Long previous() {
            return ArrayLongList.this.data[this.index--];
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            ArrayLongList.this.remove(this.index);
            this.index = Math.max(0, this.index - 1);
        }

        @Override
        public void set(Long aLong) {
            if (aLong == null) {
                throw new NullPointerException();
            }
            ArrayLongList.this.data[this.index] = aLong;
        }

        @Override
        public void add(Long aLong) {
            ArrayLongList.this.add(this.index, aLong);
        }
    }
}

