/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.leds;

import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Schema;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public class IteratorLedStream<T extends Schema>
implements LedStream<T> {
    private final Iterator<T> iterator;
    private final int schemaSize;
    private Runnable onClose;

    public static <S extends Schema> IteratorLedStream<S> fromStream(int schemaSize, Stream<S> stream) {
        return new IteratorLedStream(schemaSize, stream.iterator());
    }

    public IteratorLedStream(int schemaSize, Iterator<T> iterator) {
        this.iterator = Objects.requireNonNull(iterator);
        this.schemaSize = schemaSize;
    }

    @Override
    public void close() throws Exception {
        if (this.onClose != null) {
            this.onClose.run();
            this.onClose = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return (T)((Schema)this.iterator.next());
    }

    @Override
    public LedStream<T> onClose(Runnable onClose) {
        this.onClose = onClose;
        return this;
    }

    @Override
    public int schemaSize() {
        return this.schemaSize;
    }
}

