/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.leds;

import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Schema;
import io.intino.alexandria.led.allocators.SchemaFactory;
import io.intino.alexandria.led.allocators.stack.StackAllocator;
import io.intino.alexandria.led.allocators.stack.StackAllocators;
import io.intino.alexandria.led.util.memory.LedLibraryConfig;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import io.intino.alexandria.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class InputLedStream<T extends Schema>
implements LedStream<T> {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private final InputStream inputStream;
    private final int bufferSize;
    private final int schemaSize;
    private final SchemaFactory<T> provider;
    private final Iterator<T> iterator;
    private Runnable onClose;
    private final AtomicBoolean closed;

    public InputLedStream(InputStream inputStream, Class<T> schemaClass) {
        this(inputStream, Schema.factoryOf(schemaClass), Schema.sizeOf(schemaClass), 2048);
    }

    public InputLedStream(InputStream inputStream, Class<T> schemaClass, int bufferSize) {
        this(inputStream, Schema.factoryOf(schemaClass), Schema.sizeOf(schemaClass), bufferSize);
    }

    public InputLedStream(InputStream inputStream, SchemaFactory<T> factory, int schemaSize) {
        this(inputStream, factory, schemaSize, 2048);
    }

    public InputLedStream(InputStream inputStream, SchemaFactory<T> factory, int schemaSize, int bufferSize) {
        this.inputStream = inputStream;
        this.schemaSize = schemaSize;
        this.provider = factory;
        this.bufferSize = bufferSize;
        this.closed = new AtomicBoolean();
        this.iterator = this.stream().iterator();
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return (T)((Schema)this.iterator.next());
    }

    @Override
    public LedStream<T> onClose(Runnable onClose) {
        this.onClose = onClose;
        return this;
    }

    public synchronized Stream<T> stream() {
        return Stream.generate(() -> this.read(this.inputStream)).takeWhile(inputBuffer -> this.checkInputBuffer((ByteBuffer)inputBuffer, this.inputStream)).flatMap(this::allocateAll);
    }

    @Override
    public int schemaSize() {
        return this.schemaSize;
    }

    private boolean checkInputBuffer(ByteBuffer inputBuffer, InputStream inputStream) {
        if (inputBuffer != null) {
            return true;
        }
        this.closeInputStream(inputStream);
        return false;
    }

    private synchronized void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private Stream<T> allocateAll(ByteBuffer buffer) {
        StackAllocator allocator = StackAllocators.newManaged(this.schemaSize, buffer, this.provider);
        IntStream intStream = IntStream.range(0, buffer.remaining() / this.schemaSize);
        if (LedLibraryConfig.INPUTLEDSTREAM_CONCURRENCY_ENABLED.get().booleanValue()) {
            intStream = intStream.sorted().parallel();
        }
        return intStream.mapToObj((int index) -> allocator.malloc());
    }

    private synchronized ByteBuffer read(InputStream inputStream) {
        try {
            if (inputStream == null || inputStream.available() <= 0) {
                return null;
            }
            byte[] inputBuffer = new byte[this.bufferSize * this.schemaSize];
            int bytesRead = inputStream.read(inputBuffer);
            if (bytesRead < 0) {
                return null;
            }
            ByteBuffer buffer = MemoryUtils.allocBuffer(bytesRead);
            buffer.put(inputBuffer, 0, bytesRead);
            buffer.clear();
            return buffer;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.closed.get()) {
            return;
        }
        if (this.onClose != null) {
            this.onClose.run();
            this.onClose = null;
        }
        this.inputStream.close();
        this.closed.set(true);
    }
}

