/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.leds;

import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.Schema;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import java.util.Objects;

public class IndexedLed<T extends Schema>
implements Led<T> {
    private final IndexedAllocator<T> allocator;

    public IndexedLed(IndexedAllocator<T> allocator) {
        this.allocator = Objects.requireNonNull(allocator);
    }

    @Override
    public long size() {
        return this.allocator.size();
    }

    @Override
    public int schemaSize() {
        return this.allocator.schemaSize();
    }

    @Override
    public T schema(int index) {
        if ((long)index >= this.size()) {
            throw new IndexOutOfBoundsException("Index >= " + this.size());
        }
        return this.allocator.malloc(index);
    }
}

