/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.leds;

import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.Schema;
import io.intino.alexandria.led.allocators.SchemaFactory;
import io.intino.alexandria.led.allocators.indexed.ListAllocator;

public class DynamicLed<T extends Schema>
implements Led<T> {
    private final ListAllocator<T> allocator;
    private final int schemaSize;

    public DynamicLed(int schemaSize, SchemaFactory<T> factory) {
        this.schemaSize = schemaSize;
        this.allocator = new ListAllocator<T>(1000L, schemaSize, factory);
    }

    public Schema newTransaction() {
        return this.allocator.malloc();
    }

    @Override
    public long size() {
        return this.allocator.size();
    }

    @Override
    public int schemaSize() {
        return this.schemaSize;
    }

    @Override
    public T schema(int index) {
        if ((long)index >= this.size()) {
            throw new IndexOutOfBoundsException("Index >= " + this.size());
        }
        return this.allocator.malloc(index);
    }
}

