/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.buffers.store;

import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.util.OffHeapObject;
import io.intino.alexandria.led.util.memory.MemoryAddress;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import java.nio.ByteBuffer;

public interface ByteStore
extends OffHeapObject {
    public static ByteStore wrap(byte[] array, int baseOffset, int size) {
        ByteBuffer buffer = MemoryUtils.allocBuffer(array.length);
        buffer.put(array).clear();
        return new ByteBufferStore(buffer, MemoryAddress.of(buffer), baseOffset, size);
    }

    public Object storeImpl();

    @Override
    public long baseOffset();

    default public long bitCount() {
        return this.byteSize() * 8L;
    }

    default public long shortCount() {
        return this.byteSize() / 2L;
    }

    default public long charCount() {
        return this.byteSize() / 2L;
    }

    default public long intCount() {
        return this.byteSize() / 4L;
    }

    default public long longCount() {
        return this.byteSize() / 8L;
    }

    default public long floatCount() {
        return this.byteSize() / 4L;
    }

    default public long doubleCount() {
        return this.byteSize() / 8L;
    }

    public byte getByte(int var1);

    public void setByte(int var1, byte var2);

    public short getShort(int var1);

    public void setShort(int var1, short var2);

    public char getChar(int var1);

    public void setChar(int var1, char var2);

    public int getInt(int var1);

    public void setInt(int var1, int var2);

    public long getLong(int var1);

    public void setLong(int var1, long var2);

    public float getFloat(int var1);

    public void setFloat(int var1, float var2);

    public double getDouble(int var1);

    public void setDouble(int var1, double var2);

    public void clear();

    public ByteStore slice(long var1, long var3);
}

