/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.allocators.stack;

import io.intino.alexandria.led.Schema;
import io.intino.alexandria.led.allocators.SchemaAllocator;
import io.intino.alexandria.led.allocators.SchemaFactory;
import io.intino.alexandria.led.allocators.stack.StackAllocator;
import io.intino.alexandria.led.allocators.stack.StackAllocatorFactory;
import io.intino.alexandria.led.exceptions.StackAllocatorUnderflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class StackListAllocator<T extends Schema>
implements StackAllocator<T> {
    private static final int DEFAULT_INITIAL_STACK_COUNT = 1;
    private final List<StackAllocator<T>> stackAllocators = new ArrayList<StackAllocator<T>>();
    private final AtomicInteger currentStackAllocator = new AtomicInteger(0);
    private final int elementsPerStack;
    private final int elementSize;
    private final SchemaFactory<T> schemaFactory;
    private final StackAllocatorFactory<T> stackAllocatorFactory;

    public StackListAllocator(int initialStackCount, int elementsPerStack, int elementSize, SchemaFactory<T> schemaFactory, StackAllocatorFactory<T> stackAllocatorFactory) {
        this.elementsPerStack = elementsPerStack;
        this.elementSize = elementSize;
        this.schemaFactory = schemaFactory;
        this.stackAllocatorFactory = stackAllocatorFactory;
        this.reserve(initialStackCount);
    }

    public StackListAllocator(int elementsPerStack, int elementSize, SchemaFactory<T> schemaFactory, StackAllocatorFactory<T> stackAllocatorFactory) {
        this(1, elementsPerStack, elementSize, schemaFactory, stackAllocatorFactory);
    }

    @Override
    public long stackPointer() {
        return this.currentStackAllocator().stackPointer();
    }

    @Override
    public long remainingBytes() {
        return this.currentStackAllocator().remainingBytes();
    }

    @Override
    public long size() {
        return (long)this.currentStackAllocator.get() * this.stackSize() / (long)this.elementSize;
    }

    @Override
    public synchronized T malloc() {
        int current;
        if (this.stackAllocators.isEmpty()) {
            this.allocateNewStack();
        } else if (this.remainingBytes() == 0L && (current = this.currentStackAllocator.incrementAndGet()) == this.stackAllocators.size()) {
            this.allocateNewStack();
        }
        return this.currentStackAllocator().malloc();
    }

    @Override
    public synchronized T calloc() {
        int current;
        if (this.stackAllocators.isEmpty()) {
            this.allocateNewStack();
        } else if (this.remainingBytes() == 0L && (current = this.currentStackAllocator.incrementAndGet()) == this.stackAllocators.size()) {
            this.allocateNewStack();
        }
        return this.currentStackAllocator().calloc();
    }

    @Override
    public int schemaSize() {
        return this.elementSize;
    }

    @Override
    public synchronized void pop() {
        if (this.stackPointer() == 0L) {
            if (this.currentStackAllocator.get() == 0) {
                throw new StackAllocatorUnderflowException();
            }
            this.currentStackAllocator.decrementAndGet();
        }
        this.currentStackAllocator().pop();
    }

    public void reserve(int stackCount) {
        for (int i = 0; i < stackCount; ++i) {
            this.allocateNewStack();
        }
    }

    @Override
    public synchronized void clear() {
        this.stackAllocators.forEach(StackAllocator::clear);
        this.currentStackAllocator.set(0);
    }

    @Override
    public synchronized void free() {
        this.stackAllocators.forEach(SchemaAllocator::free);
        this.stackAllocators.clear();
        this.currentStackAllocator.set(0);
    }

    @Override
    public long address() {
        return this.currentStackAllocator().address();
    }

    @Override
    public long stackSize() {
        return this.currentStackAllocator().stackSize();
    }

    private void allocateNewStack() {
        this.stackAllocators.add(this.stackAllocatorFactory.create(this.elementSize, this.elementsPerStack, this.schemaFactory));
    }

    private StackAllocator<T> currentStackAllocator() {
        if (this.stackAllocators.isEmpty()) {
            this.allocateNewStack();
        }
        return this.stackAllocators.get(this.currentStackAllocator.get());
    }
}

