/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.allocators.indexed;

import io.intino.alexandria.led.Schema;
import io.intino.alexandria.led.allocators.SchemaFactory;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.OffHeapObject;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import io.intino.alexandria.led.util.memory.ModifiableMemoryAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class ListAllocator<T extends Schema>
implements IndexedAllocator<T> {
    private final List<ModifiableMemoryAddress> addresses;
    private final int elementSize;
    private final SchemaFactory<T> factory;
    private final int elementsCountPerBuffer;
    private final Queue<Integer> freeIndices;
    private List<ByteBufferStore> stores;
    private int lastIndex;

    public ListAllocator(long elementsCountPerBuffer, int schemaSize, SchemaFactory<T> factory) {
        if (elementsCountPerBuffer * (long)schemaSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size too large for ByteBufferStore");
        }
        this.elementSize = schemaSize;
        this.factory = factory;
        this.elementsCountPerBuffer = (int)elementsCountPerBuffer;
        this.stores = new ArrayList<ByteBufferStore>();
        this.addresses = new ArrayList<ModifiableMemoryAddress>();
        this.freeIndices = new ArrayDeque<Integer>();
    }

    @Override
    public T malloc(int index) {
        while (index > this.lastPossibleIndex()) {
            this.allocateNewByteStore();
        }
        int storeIndex = this.storeIndex(index);
        ByteStore store = this.stores.get(storeIndex);
        int relativeIndex = this.storeRelativeIndex(index);
        int offset = relativeIndex * this.elementSize;
        return (T)((Schema)this.factory.newInstance(store.slice(offset, this.elementSize)));
    }

    @Override
    public T malloc() {
        int index = !this.freeIndices.isEmpty() ? this.freeIndices.poll() : this.lastIndex++;
        return this.malloc(index);
    }

    @Override
    public T calloc() {
        T instance = this.malloc();
        ((Schema)instance).clear();
        return instance;
    }

    @Override
    public T calloc(int index) {
        T instance = this.malloc(index);
        ((Schema)instance).clear();
        return instance;
    }

    @Override
    public void clear(int index) {
        if (index > this.lastIndex) {
            return;
        }
        int storeIndex = this.storeIndex(index);
        int relativeIndex = this.storeRelativeIndex(index);
        MemoryUtils.memset(this.addresses.get(storeIndex).get() + (long)(relativeIndex * this.elementSize), this.elementSize, 0);
    }

    public void free(int index) {
        if (index > this.lastIndex) {
            return;
        }
        if (index == this.lastIndex) {
            --this.lastIndex;
            return;
        }
        this.freeIndices.add(index);
    }

    public void free(Schema schema) {
        long address = schema.address();
        int index = this.stores.stream().takeWhile(store -> store.address() != address).mapToInt(this::countElements).sum();
        index = (int)((long)index + schema.baseOffset() / (long)this.elementSize);
        this.free(index);
        schema.invalidate();
    }

    private int lastPossibleIndex() {
        return this.stores.size() * this.elementsCountPerBuffer - 1;
    }

    @Override
    public long byteSize() {
        return this.stores.stream().mapToLong(OffHeapObject::byteSize).sum();
    }

    @Override
    public long size() {
        return this.lastIndex;
    }

    public int capacity() {
        return this.stores.stream().mapToInt(this::countElements).sum();
    }

    @Override
    public int schemaSize() {
        return this.elementSize;
    }

    @Override
    public void clear() {
        this.lastIndex = 0;
        this.freeIndices.clear();
    }

    @Override
    public void free() {
        if (this.stores != null) {
            for (int i = 0; i < this.stores.size(); ++i) {
                ByteBufferStore store = this.stores.get(i);
                ModifiableMemoryAddress address = this.addresses.get(i);
                if (!address.notNull()) continue;
                MemoryUtils.free(store.storeImpl());
                address.set(0L);
            }
            this.stores = null;
            this.lastIndex = Integer.MIN_VALUE;
        }
    }

    private int storeIndex(int elementIndex) {
        long end = 0L;
        for (int i = 0; i < this.stores.size(); ++i) {
            ByteStore store = this.stores.get(i);
            if ((long)elementIndex >= (end += store.byteSize() / (long)this.elementSize)) continue;
            return i;
        }
        throw new IndexOutOfBoundsException(elementIndex + " out of " + end);
    }

    private int storeRelativeIndex(int elementIndex) {
        return elementIndex % this.elementsCountPerBuffer;
    }

    private int countElements(ByteStore store) {
        return (int)(store.byteSize() / (long)this.elementSize);
    }

    private void allocateNewByteStore() {
        ByteBuffer buffer = MemoryUtils.allocBuffer(this.elementsCountPerBuffer * this.elementSize);
        ModifiableMemoryAddress address = ModifiableMemoryAddress.of(buffer);
        ByteBufferStore store = new ByteBufferStore(buffer, address, buffer.position(), buffer.capacity());
        this.stores.add(store);
        this.addresses.add(address);
    }
}

