/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.allocators;

import io.intino.alexandria.led.Schema;
import io.intino.alexandria.led.allocators.SchemaAllocator;
import io.intino.alexandria.led.allocators.SchemaFactory;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.util.memory.MemoryAddress;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import java.nio.ByteBuffer;

public class DefaultAllocator<T extends Schema>
implements SchemaAllocator<T> {
    private final int elementSize;
    private final SchemaFactory<T> factory;

    public DefaultAllocator(int schemaSize, SchemaFactory<T> factory) {
        this.elementSize = schemaSize;
        this.factory = factory;
    }

    @Override
    public long size() {
        return Long.MAX_VALUE;
    }

    @Override
    public T malloc() {
        ByteBuffer buffer = MemoryUtils.allocBuffer(this.elementSize);
        MemoryAddress address = MemoryAddress.of(buffer);
        ByteBufferStore store = new ByteBufferStore(buffer, address, 0, this.elementSize);
        return (T)((Schema)this.factory.newInstance(store));
    }

    @Override
    public T calloc() {
        T instance = this.malloc();
        ((Schema)instance).clear();
        return instance;
    }

    @Override
    public int schemaSize() {
        return this.elementSize;
    }

    @Override
    public void clear() {
    }

    @Override
    public void free() {
    }
}

