/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.HeapLedStreamBuilder;
import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.LedWriter;
import io.intino.alexandria.led.Schema;
import io.intino.alexandria.led.allocators.SchemaAllocator;
import io.intino.alexandria.led.allocators.SchemaFactory;
import io.intino.alexandria.led.allocators.stack.StackAllocators;
import io.intino.alexandria.led.allocators.stack.StackListAllocator;
import io.intino.alexandria.led.leds.IteratorLedStream;
import io.intino.alexandria.led.util.iterators.IteratorUtils;
import io.intino.alexandria.led.util.iterators.MergedIterator;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface LedStream<T extends Schema>
extends Iterator<T>,
AutoCloseable {
    public static <T extends Schema> LedStream<T> empty() {
        return IteratorLedStream.fromStream(0, Stream.empty());
    }

    public static <T extends Schema> LedStream<T> fromLed(Led<T> led) {
        return led.toLedStream();
    }

    public static <T extends Schema> LedStream<T> fromStream(int schemaSize, Stream<T> stream) {
        return IteratorLedStream.fromStream(schemaSize, stream);
    }

    public static <T extends Schema> LedStream<T> of(int schemaSize, T ... schemas) {
        return LedStream.fromStream(schemaSize, Arrays.stream(schemas));
    }

    public static <T extends Schema> LedStream<T> singleton(int schemaSize, T schema) {
        return LedStream.fromStream(schemaSize, Stream.of(schema));
    }

    public static <T extends Schema> LedStream<T> merged(Stream<LedStream<T>> ledStreams) {
        return LedStream.merged(ledStreams.iterator());
    }

    public static <T extends Schema> LedStream<T> merged(Iterator<LedStream<T>> iterator) {
        if (!iterator.hasNext()) {
            return LedStream.empty();
        }
        return iterator.next().merge(IteratorUtils.streamOf(iterator));
    }

    public static <T extends Schema> Builder<T> builder(Class<T> schemaClass) {
        return new HeapLedStreamBuilder<T>(schemaClass);
    }

    public static <T extends Schema> Builder<T> builder(Class<T> schemaClass, File tempDirectory) {
        return new HeapLedStreamBuilder<T>(schemaClass, tempDirectory);
    }

    public static <T extends Schema> Builder<T> builder(Class<T> schemaClass, int numElementsPerBlock) {
        return new HeapLedStreamBuilder<T>(schemaClass, numElementsPerBlock);
    }

    public static <T extends Schema> Builder<T> builder(Class<T> schemaClass, int numElementsPerBlock, File tempDirectory) {
        return new HeapLedStreamBuilder<T>(schemaClass, numElementsPerBlock, tempDirectory);
    }

    public static <T extends Schema> Builder<T> builder(Class<T> schemaClass, SchemaFactory<T> factory) {
        return new HeapLedStreamBuilder<T>(schemaClass, factory);
    }

    public static <T extends Schema> Builder<T> builder(Class<T> schemaClass, SchemaFactory<T> factory, File tempDirectory) {
        return new HeapLedStreamBuilder<T>(schemaClass, factory, tempDirectory);
    }

    public static <T extends Schema> Builder<T> builder(Class<T> schemaClass, SchemaFactory<T> factory, int numElementsPerBlock) {
        return new HeapLedStreamBuilder<T>(schemaClass, factory, numElementsPerBlock);
    }

    public static <T extends Schema> Builder<T> builder(Class<T> schemaClass, SchemaFactory<T> factory, int numElementsPerBlock, File tempDirectory) {
        return new HeapLedStreamBuilder<T>(schemaClass, factory, numElementsPerBlock, tempDirectory);
    }

    public int schemaSize();

    @Override
    public boolean hasNext();

    @Override
    public T next();

    default public Spliterator<T> spliterator() {
        return Spliterators.spliteratorUnknownSize(this, 4);
    }

    default public Stream<T> asJavaStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public LedStream<T> filter(Predicate<T> condition) {
        return new Filter<T>(this, condition);
    }

    default public LedStream<T> peek(Consumer<T> consumer) {
        return new Peek<T>(this, consumer);
    }

    default public <R extends Schema> LedStream<R> map(SchemaAllocator<R> allocator, BiConsumer<T, R> mapper) {
        return new Map<T, R>(this, allocator, mapper);
    }

    default public <R extends Schema> LedStream<R> map(int rSize, SchemaFactory<R> factory, BiConsumer<T, R> mapper) {
        return new Map<T, R>(this, rSize, factory, mapper);
    }

    default public <R extends Schema> LedStream<R> map(Class<R> newType, BiConsumer<T, R> mapper) {
        return new Map<T, R>(this, Schema.sizeOf(newType), Schema.factoryOf(newType), mapper);
    }

    default public <R> Stream<R> mapToObj(Function<T, R> mapper) {
        return this.asJavaStream().map(mapper);
    }

    default public LedStream<T> merge(LedStream<T> other) {
        return new Merge<T>(this, other);
    }

    default public LedStream<T> merge(Stream<LedStream<T>> others) {
        return new Merge<T>(this, others);
    }

    default public <O extends Schema> LedStream<T> removeAll(LedStream<O> other) {
        return new RemoveAll(this, other);
    }

    default public LedStream<T> removeAll(Iterable<Long> other) {
        return new RemoveAll(this, other.iterator());
    }

    default public LedStream<T> removeAll(Iterator<Long> other) {
        return new RemoveAll(this, other);
    }

    default public <O extends Schema> LedStream<T> retainAll(LedStream<O> other) {
        return new RetainAll(this, other);
    }

    default public LedStream<T> retainAll(Iterable<Long> other) {
        return new RetainAll(this, other.iterator());
    }

    default public LedStream<T> retainAll(Iterator<Long> other) {
        return new RetainAll(this, other);
    }

    default public Optional<T> findFirst() {
        return this.hasNext() ? Optional.ofNullable(this.next()) : Optional.empty();
    }

    default public Optional<T> findLast() {
        Object last = null;
        while (this.hasNext()) {
            last = this.next();
        }
        return Optional.ofNullable(last);
    }

    default public boolean allMatch(Predicate<T> condition) {
        while (this.hasNext()) {
            if (condition.test(this.next())) continue;
            return false;
        }
        return true;
    }

    default public boolean anyMatch(Predicate<T> condition) {
        while (this.hasNext()) {
            if (!condition.test(this.next())) continue;
            return true;
        }
        return false;
    }

    default public boolean noneMatch(Predicate<T> condition) {
        while (this.hasNext()) {
            if (!condition.test(this.next())) continue;
            return false;
        }
        return true;
    }

    default public void forEach(Consumer<T> consumer) {
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }

    default public void serialize(File file) {
        LedWriter ledWriter = new LedWriter(file);
        ledWriter.write(this);
    }

    default public void serializeUncompressed(File file) {
        LedWriter ledWriter = new LedWriter(file);
        ledWriter.writeUncompressed(this);
    }

    default public LedStream<T> onClose(Runnable onClose) {
        return this;
    }

    public static interface Builder<T extends Schema> {
        public Class<T> schemaClass();

        public int schemaSize();

        public Builder<T> append(Consumer<T> var1);

        public LedStream<T> build();
    }

    public static class Map<T extends Schema, R extends Schema>
    extends LedStreamOperation<T, R> {
        private static final int DEFAULT_ELEMENTS_PER_STACK = 1024;
        private final SchemaAllocator<R> allocator;
        private final BiConsumer<T, R> mapper;

        public Map(LedStream<T> source, SchemaAllocator<R> allocator, BiConsumer<T, R> mapper) {
            super(source);
            this.allocator = Objects.requireNonNull(allocator);
            this.mapper = Objects.requireNonNull(mapper);
        }

        public Map(LedStream<T> source, int rSize, SchemaFactory<R> factory, BiConsumer<T, R> mapper) {
            this(source, Map.getDefaultAllocator(rSize, factory), mapper);
        }

        @Override
        public int schemaSize() {
            return this.allocator.schemaSize();
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public R next() {
            R newElement = this.allocator.calloc();
            this.mapper.accept(this.source.next(), newElement);
            return newElement;
        }

        private static <R extends Schema> SchemaAllocator<R> getDefaultAllocator(int rSize, SchemaFactory<R> factory) {
            return new StackListAllocator<R>(1024, rSize, factory, StackAllocators::newManaged);
        }
    }

    public static class RetainAll<T extends Schema>
    extends LedStreamOperation<T, T> {
        private final Iterator<Long> other;
        private T current;

        public RetainAll(LedStream<T> source, LedStream<?> other) {
            this(source, other.mapToObj(Schema::idOf).iterator());
        }

        public RetainAll(LedStream<T> source, Iterator<Long> idIterator) {
            super(source);
            this.other = Objects.requireNonNull(idIterator);
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.advanceToNextElement();
            }
            return this.current != null;
        }

        private void advanceToNextElement() {
            if (!this.source.hasNext() || !this.other.hasNext()) {
                return;
            }
            Object sourceElement = this.source.next();
            long otherElementId = this.other.next();
            while (Schema.idOf((Schema)sourceElement) < otherElementId) {
                if (!this.source.hasNext()) {
                    return;
                }
                sourceElement = this.source.next();
            }
            while (Schema.idOf((Schema)sourceElement) > otherElementId) {
                if (!this.other.hasNext()) {
                    return;
                }
                otherElementId = this.other.next();
            }
            if (Schema.idOf((Schema)sourceElement) == otherElementId) {
                this.current = sourceElement;
            }
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T next = this.current;
            this.current = null;
            return next;
        }
    }

    public static class Merge<T extends Schema>
    extends LedStreamOperation<T, T> {
        private final MergedIterator<T> mergedIterator;

        public Merge(LedStream<T> source, LedStream<T> other) {
            super(source);
            this.mergedIterator = new MergedIterator<Schema>(Stream.of(source, Objects.requireNonNull(other)), Comparator.comparingLong(Schema::idOf));
        }

        public Merge(LedStream<T> source, Stream<LedStream<T>> others) {
            super(source);
            this.mergedIterator = new MergedIterator<Schema>(Stream.concat(Stream.of(source), others), Comparator.comparingLong(Schema::idOf));
        }

        @Override
        public boolean hasNext() {
            return this.mergedIterator.hasNext();
        }

        @Override
        public T next() {
            return (T)((Schema)this.mergedIterator.next());
        }
    }

    public static class RemoveAll<T extends Schema>
    extends LedStreamOperation<T, T> {
        private final Iterator<Long> other;
        private T sourceCurrent;
        private Long otherCurrentId;

        public RemoveAll(LedStream<T> source, LedStream<?> other) {
            this(source, other.mapToObj(Schema::idOf).iterator());
        }

        public RemoveAll(LedStream<T> source, Iterator<Long> idIterator) {
            super(source);
            this.other = Objects.requireNonNull(idIterator);
        }

        @Override
        public boolean hasNext() {
            if (this.sourceCurrent == null) {
                this.advanceToNextElement();
            }
            return this.sourceCurrent != null;
        }

        private void advanceToNextElement() {
            if (!this.source.hasNext()) {
                return;
            }
            if (!this.other.hasNext()) {
                this.sourceCurrent = this.source.next();
                this.otherCurrentId = null;
                return;
            }
            Object sourceElement = this.source.next();
            if (this.otherCurrentId == null) {
                this.otherCurrentId = this.other.next();
            }
            if (Schema.idOf((Schema)sourceElement) < this.otherCurrentId) {
                this.sourceCurrent = sourceElement;
                return;
            }
            while (Schema.idOf((Schema)sourceElement) > this.otherCurrentId) {
                if (this.other.hasNext()) {
                    this.otherCurrentId = this.other.next();
                    continue;
                }
                this.sourceCurrent = sourceElement;
                this.otherCurrentId = null;
                return;
            }
            do {
                long id;
                int comparison;
                if ((comparison = Long.compare(id = Schema.idOf((Schema)sourceElement), this.otherCurrentId)) == 0) {
                    if (this.source.hasNext()) {
                        sourceElement = this.source.next();
                        continue;
                    }
                    this.sourceCurrent = null;
                    return;
                }
                if (comparison <= 0) continue;
                if (this.other.hasNext()) {
                    this.otherCurrentId = this.other.next();
                    continue;
                }
                this.otherCurrentId = null;
                break;
            } while (Schema.idOf((Schema)sourceElement) >= this.otherCurrentId);
            this.sourceCurrent = sourceElement;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T next = this.sourceCurrent;
            this.sourceCurrent = null;
            return next;
        }
    }

    public static class Peek<T extends Schema>
    extends LedStreamOperation<T, T> {
        private final Consumer<T> consumer;

        public Peek(LedStream<T> source, Consumer<T> consumer) {
            super(source);
            this.consumer = Objects.requireNonNull(consumer);
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public T next() {
            Object next = this.source.next();
            this.consumer.accept(next);
            return (T)next;
        }
    }

    public static class Filter<T extends Schema>
    extends LedStreamOperation<T, T> {
        private final Predicate<T> condition;
        private T current;

        public Filter(LedStream<T> source, Predicate<T> condition) {
            super(source);
            this.condition = Objects.requireNonNull(condition);
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.advanceToNextElement();
            }
            return this.current != null;
        }

        private void advanceToNextElement() {
            while (this.source.hasNext()) {
                Object next = this.source.next();
                if (!this.condition.test(next)) continue;
                this.current = next;
                break;
            }
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T next = this.current;
            this.current = null;
            return next;
        }
    }

    public static abstract class LedStreamOperation<T extends Schema, R extends Schema>
    implements LedStream<R> {
        protected final LedStream<T> source;
        private Runnable onClose;
        private boolean closed;

        public LedStreamOperation(LedStream<T> source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public int schemaSize() {
            return this.source.schemaSize();
        }

        @Override
        public LedStream<R> onClose(Runnable onClose) {
            this.onClose = onClose;
            return this;
        }

        @Override
        public void close() throws Exception {
            if (this.closed) {
                return;
            }
            if (this.onClose != null) {
                this.onClose.run();
            }
            this.source.close();
            this.closed = true;
        }
    }
}

