/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.Schema;
import io.intino.alexandria.led.allocators.SchemaFactory;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import io.intino.alexandria.led.allocators.indexed.ListAllocator;
import io.intino.alexandria.led.leds.ListLed;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class LedBuilder<T extends Schema>
implements Led.Builder<T> {
    public static final int DEFAULT_INITIAL_CAPACITY = 1024;
    public static final float GROW_FACTOR = 1.5f;
    private final Class<T> schemaClass;
    private final IndexedAllocator<T> allocator;
    private T[] sortedTransactions;
    private int size;

    public LedBuilder(Class<T> schemaClass) {
        this(schemaClass, Schema.factoryOf(schemaClass));
    }

    public LedBuilder(Class<T> schemaClass, SchemaFactory<T> factory) {
        this(schemaClass, LedBuilder.createBuilderDefaultAllocator(Schema.sizeOf(schemaClass), factory));
    }

    public LedBuilder(Class<T> schemaClass, IndexedAllocator<T> allocator) {
        this.schemaClass = Objects.requireNonNull(schemaClass);
        this.allocator = Objects.requireNonNull(allocator);
        this.sortedTransactions = new Schema[1024];
    }

    @Override
    public Class<T> schemaClass() {
        return this.schemaClass;
    }

    @Override
    public int schemaSize() {
        return this.allocator.schemaSize();
    }

    @Override
    public Led.Builder<T> create(Consumer<T> initializer) {
        Object schema = this.allocator.malloc();
        initializer.accept(schema);
        this.putInSortedList(schema);
        return this;
    }

    private void putInSortedList(T schema) {
        if (this.size == this.sortedTransactions.length) {
            this.grow();
        } else if (this.size == 0) {
            this.sortedTransactions[0] = schema;
        } else {
            int index = Arrays.binarySearch(this.sortedTransactions, 0, this.size, schema);
            if (index < 0) {
                index = -index + 1;
            }
            System.arraycopy(this.sortedTransactions, index, this.sortedTransactions, index + 1, ++this.size - index);
            this.sortedTransactions[index] = schema;
        }
    }

    private void grow() {
        this.sortedTransactions = (Schema[])Arrays.copyOf(this.sortedTransactions, Math.round((float)this.size * 1.5f));
    }

    @Override
    public Led<T> build() {
        return new ListLed<T>(this.getList());
    }

    private List<T> getList() {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index >= LedBuilder.this.size) {
                    throw new IndexOutOfBoundsException(index + " >= " + LedBuilder.this.size);
                }
                return LedBuilder.this.sortedTransactions[index];
            }

            @Override
            public int size() {
                return LedBuilder.this.size;
            }
        };
    }

    private static <T extends Schema> IndexedAllocator<T> createBuilderDefaultAllocator(int schemaSize, SchemaFactory<T> factory) {
        return new ListAllocator<T>(1024L, schemaSize, factory);
    }
}

