/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.sorting;

import io.intino.alexandria.led.GenericTransaction;
import io.intino.alexandria.led.LedHeader;
import io.intino.alexandria.led.LedReader;
import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.util.LedUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

class TestDigestion2019 {
    private static final File UNSORTED_SESSION_FILES_DIR = new File("G:\\leds");
    private static final int NUM_TRANSACTIONS_IN_MEMORY = 500000;
    private final File sessionUnsortedLedFile;
    private final File destinationSortedLedFile;

    public static void main(String[] args) {
        int numThreads = Runtime.getRuntime().availableProcessors() - 1;
        int numTransactions = 500000;
        System.out.println("Num threads = " + numThreads);
        System.out.println("Num transactions per thread = 500000");
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        for (File srcFile : TestDigestion2019.getParameters()) {
            TestDigestion2019 test = new TestDigestion2019(srcFile);
            threadPool.submit(() -> test.doTest(500000));
        }
    }

    public static Collection<File> getParameters() {
        File[] files = UNSORTED_SESSION_FILES_DIR.listFiles();
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        System.out.println(">> Loading " + files.length + " files...");
        return Arrays.stream(files).filter(file -> {
            if (file.isDirectory() || file.getName().startsWith("sorted_")) {
                file.delete();
                file.deleteOnExit();
                return false;
            }
            return true;
        }).collect(Collectors.toUnmodifiableList());
    }

    public TestDigestion2019(File sessionUnsortedLedFile) {
        this.sessionUnsortedLedFile = sessionUnsortedLedFile;
        this.destinationSortedLedFile = new File("temp/sorted_leds/", "sorted_" + sessionUnsortedLedFile.getName() + ".led");
        this.destinationSortedLedFile.getParentFile().mkdirs();
    }

    public void test() {
        this.doTest(500000);
    }

    private void doTest(int numTransactionsInMemory) {
        try {
            System.out.println(">> Testing " + this.sessionUnsortedLedFile + "(" + (double)this.sessionUnsortedLedFile.length() / 1024.0 / 1024.0 + " MB)...");
            LedHeader sourceHeader = LedHeader.from(this.sessionUnsortedLedFile);
            LedUtils.sort(this.sessionUnsortedLedFile, this.destinationSortedLedFile, numTransactionsInMemory);
            System.out.println("\t>> Validating result led...");
            LedHeader destHeader = LedHeader.from(this.destinationSortedLedFile);
            if (sourceHeader.elementCount() != destHeader.elementCount()) {
                throw new AssertionError((Object)"Incongruent information");
            }
            try (LedStream<GenericTransaction> ledStream = new LedReader(this.destinationSortedLedFile).read(GenericTransaction::new);){
                long lastId = Long.MIN_VALUE;
                while (ledStream.hasNext()) {
                    long id = Transaction.idOf((Transaction)ledStream.next());
                    if (id < lastId) {
                        throw new AssertionError();
                    }
                    lastId = id;
                }
            }
            System.out.println(">> " + this.sessionUnsortedLedFile + " sorting was successful.");
        }
        catch (AssertionError assertionError) {
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        System.out.println();
    }
}

