/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.memory;

import io.intino.alexandria.led.util.memory.AllocationInfo;
import io.intino.alexandria.led.util.memory.NativeMemoryTracker;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

class NativeMemoryTrackerImpl
implements NativeMemoryTracker {
    private final Queue<AllocationInfo> liveAllocations = new ConcurrentLinkedQueue<AllocationInfo>();

    void track(AllocationInfo allocationInfo) {
        this.removeGarbageCollectedAllocations();
        this.liveAllocations.add(allocationInfo);
    }

    @Override
    public List<AllocationInfo> getLiveAllocations() {
        this.removeGarbageCollectedAllocations();
        return this.liveAllocations.stream().collect(Collectors.toUnmodifiableList());
    }

    @Override
    public int numLiveAllocations() {
        this.removeGarbageCollectedAllocations();
        return this.liveAllocations.size();
    }

    @Override
    public long totalAllocationSize() {
        return this.liveAllocations.stream().mapToLong(AllocationInfo::size).sum();
    }

    private void removeGarbageCollectedAllocations() {
        this.liveAllocations.removeIf(AllocationInfo::isGarbageCollected);
    }
}

