/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.memory;

import io.intino.alexandria.led.util.memory.AllocationInfo;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class LedLibraryConfig {
    public static final Variable<ByteOrder> DEFAULT_BYTE_ORDER = new Variable<ByteOrder>(ByteOrder.nativeOrder());
    public static final Variable<Boolean> USE_MEMORY_TRACKER = new Variable<Boolean>(false);
    public static final Variable<Consumer<Long>> BEFORE_ALLOCATION_CALLBACK = new Variable();
    public static final Variable<Consumer<AllocationInfo>> ALLOCATION_CALLBACK = new Variable();
    public static final Variable<Consumer<AllocationInfo>> FREE_CALLBACK = new Variable();
    public static final Variable<Integer> DEFAULT_BUFFER_SIZE = new Variable<Integer>(1024);
    public static final Variable<Boolean> INPUTLEDSTREAM_CONCURRENCY_ENABLED = new Variable<Boolean>(false);

    private LedLibraryConfig() {
    }

    public static final class Variable<T> {
        private final AtomicReference<T> value = new AtomicReference();

        Variable() {
        }

        Variable(T defaultValue) {
            this();
            this.set(defaultValue);
        }

        public boolean isEmpty() {
            return this.value.get() == null;
        }

        public T get() {
            return this.value.get();
        }

        public T getOrDefault(T newValue) {
            if (this.isEmpty()) {
                this.set(newValue);
            }
            return this.value.get();
        }

        public Variable<T> set(T value) {
            this.value.set(Objects.requireNonNull(value));
            return this;
        }
    }
}

