/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.memory;

import io.intino.alexandria.led.util.memory.MemoryAddress;
import io.intino.alexandria.led.util.memory.ModifiableMemoryAddress;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class AllocationInfo
implements Comparable<AllocationInfo> {
    private final WeakReference<ByteBuffer> buffer;
    private final StackTraceElement[] allocationStackTrace;
    private final long size;
    private final long timestamp;

    public AllocationInfo(ByteBuffer buffer, long size, StackTraceElement[] stackTrace) {
        this.buffer = new WeakReference<ByteBuffer>(buffer);
        this.size = size;
        this.allocationStackTrace = stackTrace;
        this.timestamp = System.currentTimeMillis();
    }

    public boolean isGarbageCollected() {
        return this.buffer.get() == null;
    }

    public MemoryAddress address() {
        return this.isGarbageCollected() ? new ModifiableMemoryAddress(0L) : MemoryAddress.of((ByteBuffer)this.buffer.get());
    }

    public long size() {
        return this.size;
    }

    public float sizeKB() {
        return (float)this.size / 1024.0f;
    }

    public float sizeMB() {
        return (float)this.size / 1024.0f / 1024.0f;
    }

    public float sizeGB() {
        return (float)this.size / 1024.0f / 1024.0f / 1024.0f;
    }

    public StackTraceElement[] allocationStackTrace() {
        return this.allocationStackTrace;
    }

    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public int compareTo(AllocationInfo o) {
        return Long.compare(this.size, o.size);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllocationInfo that = (AllocationInfo)o;
        return this.size == that.size && this.timestamp == that.timestamp && Objects.equals(this.buffer, that.buffer) && Arrays.equals(this.allocationStackTrace, that.allocationStackTrace);
    }

    public int hashCode() {
        int result = Objects.hash(this.buffer, this.size, this.timestamp);
        result = 31 * result + Arrays.hashCode(this.allocationStackTrace);
        return result;
    }

    public String toString() {
        return "AllocationInfo{buffer=" + (Comparable)(this.isGarbageCollected() ? "(DELETED)" : (Comparable)this.buffer.get()) + ",address=" + this.address().get() + ",size=" + (this.size < 100000L ? this.sizeKB() + " KB" : this.sizeMB() + " MB") + ",allocationStackTrace=" + Arrays.stream(this.allocationStackTrace).map(this::printStackTraceElement).collect(Collectors.joining(", ")) + ",dateTime=" + Instant.ofEpochMilli(this.timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime() + "}";
    }

    public String toStringPretty() {
        return "AllocationInfo {\n buffer=" + (Comparable)(this.isGarbageCollected() ? "(DELETED)" : (Comparable)this.buffer.get()) + ",\n address=" + this.address().get() + ",\n size=" + (this.size < 100000L ? this.sizeKB() + " KB" : this.sizeMB() + " MB") + ",\n allocationStackTrace=[" + Arrays.stream(this.allocationStackTrace).map(this::printStackTraceElement).collect(Collectors.joining("\n\t\t\tat ")) + "],\n dateTime=" + Instant.ofEpochMilli(this.timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime() + "\n}";
    }

    private String printStackTraceElement(StackTraceElement st) {
        return st.getClassName() + "." + st.getMethodName() + "(" + st.getFileName() + ":" + st.getLineNumber() + ")";
    }
}

