/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.leds;

import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.stack.StackAllocator;
import io.intino.alexandria.led.allocators.stack.StackAllocators;
import io.intino.alexandria.led.util.memory.LedLibraryConfig;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ByteChannelLedStream<T extends Transaction>
implements LedStream<T> {
    private final FileChannel byteChannel;
    private final long fileSize;
    private final int bufferSize;
    private final int transactionSize;
    private final TransactionFactory<T> provider;
    private final Iterator<T> iterator;
    private Runnable onClose;
    private final AtomicBoolean closed;

    public ByteChannelLedStream(File file, Class<T> transactionClass) {
        this(file, Transaction.factoryOf(transactionClass), Transaction.sizeOf(transactionClass), LedLibraryConfig.DEFAULT_BUFFER_SIZE.get());
    }

    public ByteChannelLedStream(File file, Class<T> transactionClass, int bufferSize) {
        this(file, Transaction.factoryOf(transactionClass), Transaction.sizeOf(transactionClass), bufferSize);
    }

    public ByteChannelLedStream(File file, TransactionFactory<T> factory, int transactionSize) {
        this(file, factory, transactionSize, LedLibraryConfig.DEFAULT_BUFFER_SIZE.get());
    }

    public ByteChannelLedStream(File file, TransactionFactory<T> factory, int transactionSize, int bufferSize) {
        this.byteChannel = this.open(file);
        this.fileSize = this.getFileSize();
        this.transactionSize = transactionSize;
        this.provider = factory;
        this.bufferSize = bufferSize;
        this.closed = new AtomicBoolean();
        this.iterator = this.stream().iterator();
    }

    private long getFileSize() {
        try {
            return this.byteChannel.size();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private FileChannel open(File file) {
        try {
            FileChannel byteChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
            byteChannel.position(0L);
            return byteChannel;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return (T)((Transaction)this.iterator.next());
    }

    @Override
    public LedStream<T> onClose(Runnable onClose) {
        this.onClose = onClose;
        return this;
    }

    public synchronized Stream<T> stream() {
        return Stream.generate(() -> this.read(this.byteChannel)).takeWhile(inputBuffer -> this.checkInputBuffer((ByteBuffer)inputBuffer, this.byteChannel)).flatMap(this::allocateAll);
    }

    @Override
    public int transactionSize() {
        return this.transactionSize;
    }

    private boolean checkInputBuffer(ByteBuffer inputBuffer, FileChannel byteChannel) {
        if (inputBuffer != null) {
            return true;
        }
        this.closeByteChannel(byteChannel);
        return false;
    }

    private synchronized void closeByteChannel(FileChannel byteChannel) {
        try {
            byteChannel.close();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private Stream<T> allocateAll(ByteBuffer buffer) {
        StackAllocator allocator = StackAllocators.newManaged(this.transactionSize, buffer, this.provider);
        IntStream intStream = IntStream.range(0, buffer.remaining() / this.transactionSize);
        if (LedLibraryConfig.INPUTLEDSTREAM_CONCURRENCY_ENABLED.get().booleanValue()) {
            intStream = intStream.sorted().parallel();
        }
        return intStream.mapToObj((int index) -> allocator.malloc());
    }

    private synchronized ByteBuffer read(FileChannel byteChannel) {
        try {
            if (byteChannel == null) {
                return null;
            }
            long filePosition = byteChannel.position();
            if (!byteChannel.isOpen() || filePosition >= this.fileSize) {
                return null;
            }
            int size = (int)Math.min((long)this.bufferSize, this.fileSize - filePosition) * this.transactionSize;
            ByteBuffer buffer = MemoryUtils.allocBuffer(size);
            int bytesRead = byteChannel.read(buffer);
            if (bytesRead <= 0) {
                return null;
            }
            buffer.position(0).limit(bytesRead);
            return buffer;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.closed.get()) {
            return;
        }
        if (this.onClose != null) {
            this.onClose.run();
            this.onClose = null;
        }
        if (this.byteChannel != null) {
            this.byteChannel.close();
        }
        this.closed.set(true);
    }
}

