/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.allocators.stack;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.stack.SingleStackAllocator;
import io.intino.alexandria.led.allocators.stack.StackAllocator;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.buffers.store.NativePointerStore;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import io.intino.alexandria.led.util.memory.ModifiableMemoryAddress;
import java.nio.ByteBuffer;

public final class StackAllocators {
    public static <E extends Transaction> StackAllocator<E> newUnmanaged(int elementSize, long elementCount, TransactionFactory<E> provider) {
        long size = (long)elementSize * elementCount;
        long ptr = MemoryUtils.malloc(size);
        ModifiableMemoryAddress address = new ModifiableMemoryAddress(ptr);
        NativePointerStore store = new NativePointerStore(address, 0L, size);
        return new SingleStackAllocator<E>(store, address, elementSize, provider);
    }

    public static <E extends Transaction> StackAllocator<E> newManaged(int elementSize, long elementCount, TransactionFactory<E> provider) {
        if (elementCount < 0L) {
            throw new IllegalArgumentException("Element count is negative");
        }
        if (elementCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Element Count too large for managed byte store");
        }
        long size = (long)elementSize * elementCount;
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size too large for managed byte store");
        }
        ByteBuffer buffer = MemoryUtils.allocBuffer((int)size);
        ModifiableMemoryAddress address = ModifiableMemoryAddress.of(buffer);
        ByteBufferStore store = new ByteBufferStore(buffer, address, 0, (int)size);
        return new SingleStackAllocator<E>(store, address, elementSize, provider);
    }

    public static <E extends Transaction> StackAllocator<E> newManaged(int elementSize, ByteBuffer buffer, TransactionFactory<E> provider) {
        ModifiableMemoryAddress address = ModifiableMemoryAddress.of(buffer);
        ByteBufferStore store = new ByteBufferStore(buffer, address, 0, buffer.remaining());
        return new SingleStackAllocator<E>(store, address, elementSize, provider);
    }

    private StackAllocators() {
    }
}

