/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.allocators.indexed;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import io.intino.alexandria.led.util.memory.ModifiableMemoryAddress;
import java.nio.ByteBuffer;

public class ManagedIndexedAllocator<T extends Transaction>
implements IndexedAllocator<T> {
    private ByteBufferStore store;
    private final ModifiableMemoryAddress address;
    private final int transactionSize;
    private final TransactionFactory<T> factory;

    public ManagedIndexedAllocator(ByteBuffer buffer, int baseOffset, int size, int transactionSize, TransactionFactory<T> factory) {
        this.transactionSize = transactionSize;
        this.factory = factory;
        this.address = ModifiableMemoryAddress.of(buffer);
        this.store = new ByteBufferStore(buffer, this.address, baseOffset, size);
    }

    public ManagedIndexedAllocator(long elementsCount, int transactionSize, TransactionFactory<T> factory) {
        this.transactionSize = transactionSize;
        this.factory = factory;
        long size = elementsCount * (long)transactionSize;
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size too large for ManagedIndexedAllocator");
        }
        ByteBuffer buffer = MemoryUtils.allocBuffer((int)size);
        this.address = ModifiableMemoryAddress.of(buffer);
        this.store = new ByteBufferStore(buffer, this.address, 0, (int)size);
    }

    @Override
    public T malloc(int index) {
        int offset = index * this.transactionSize;
        return (T)((Transaction)this.factory.newInstance(this.store.slice(offset, this.transactionSize)));
    }

    @Override
    public T calloc(int index) {
        T instance = this.malloc(index);
        ((Transaction)instance).clear();
        return instance;
    }

    @Override
    public T malloc() {
        return this.malloc(0);
    }

    @Override
    public T calloc() {
        return this.calloc(0);
    }

    @Override
    public void clear(int index) {
    }

    @Override
    public long byteSize() {
        return this.store.byteSize();
    }

    @Override
    public long size() {
        return (int)(this.byteSize() / (long)this.transactionSize);
    }

    @Override
    public int transactionSize() {
        return this.transactionSize;
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public void free() {
        if (this.address.get() != 0L) {
            MemoryUtils.free(this.store.storeImpl());
            this.store = null;
            this.address.set(0L);
        }
    }
}

