/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.LedHeader;
import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.stack.StackAllocator;
import io.intino.alexandria.led.allocators.stack.StackAllocators;
import io.intino.alexandria.led.leds.InputLedStream;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class UnsortedLedStreamBuilder<T extends Transaction>
implements LedStream.Builder<T>,
AutoCloseable {
    private static final int DEFAULT_NUM_ELEMENTS_PER_BLOCK = 500000;
    private final Class<T> transactionClass;
    private final int transactionSize;
    private final TransactionFactory<T> factory;
    private final Path tempLedFile;
    private ByteBuffer buffer;
    private StackAllocator<T> allocator;
    private FileChannel fileChannel;
    private long numTransactions;
    private final boolean keepFileChannelOpen;
    private final AtomicBoolean closed;

    public UnsortedLedStreamBuilder(Class<T> transactionClass, File tempFile) {
        this(transactionClass, Transaction.factoryOf(transactionClass), 500000, tempFile, true);
    }

    public UnsortedLedStreamBuilder(Class<T> transactionClass, File tempFile, boolean keepFileChannelOpen) {
        this(transactionClass, Transaction.factoryOf(transactionClass), 500000, tempFile, keepFileChannelOpen);
    }

    public UnsortedLedStreamBuilder(Class<T> transactionClass, TransactionFactory<T> factory, int numElementsPerBlock, File tempFile) {
        this(transactionClass, factory, numElementsPerBlock, tempFile, true);
    }

    public UnsortedLedStreamBuilder(Class<T> transactionClass, TransactionFactory<T> factory, int numElementsPerBlock, File tempFile, boolean keepFileChannelOpen) {
        this.transactionClass = transactionClass;
        this.transactionSize = Transaction.sizeOf(transactionClass);
        this.factory = factory;
        tempFile.getParentFile().mkdirs();
        this.tempLedFile = tempFile.toPath();
        if (numElementsPerBlock % 2 != 0) {
            throw new IllegalArgumentException("NumElementsPerBlock must be even");
        }
        this.buffer = MemoryUtils.allocBuffer((long)numElementsPerBlock * (long)this.transactionSize);
        this.allocator = StackAllocators.newManaged(this.transactionSize, this.buffer, factory);
        this.keepFileChannelOpen = keepFileChannelOpen;
        this.closed = new AtomicBoolean(false);
        this.setupFile();
    }

    private void setupFile() {
        try {
            Files.createFile(this.tempLedFile, new FileAttribute[0]);
            if (this.keepFileChannelOpen) {
                this.fileChannel = this.openFileChannel();
            }
            this.reserveHeader();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public File tempLedFile() {
        return this.tempLedFile.toFile();
    }

    private FileChannel openFileChannel() throws IOException {
        return FileChannel.open(this.tempLedFile, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
    }

    private void reserveHeader() throws IOException {
        if (!this.keepFileChannelOpen) {
            this.fileChannel = this.openFileChannel();
        }
        this.fileChannel.write(ByteBuffer.allocate(12));
        if (!this.keepFileChannelOpen) {
            this.fileChannel.close();
        }
    }

    @Override
    public Class<T> transactionClass() {
        return this.transactionClass;
    }

    @Override
    public int transactionSize() {
        return this.transactionSize;
    }

    @Override
    public LedStream.Builder<T> append(Consumer<T> initializer) {
        if (this.isClosed()) {
            Logger.error((String)"Trying to use a closed builder.");
            return this;
        }
        T transaction = this.allocator.calloc();
        initializer.accept(transaction);
        if (this.allocator.remainingBytes() == 0L) {
            this.writeCurrentBlockAndClear();
        }
        ++this.numTransactions;
        return this;
    }

    private void writeCurrentBlockAndClear() {
        try {
            if (!this.keepFileChannelOpen) {
                this.fileChannel = this.openFileChannel();
            }
            this.buffer.limit((int)this.allocator.stackPointer());
            while (this.buffer.hasRemaining()) {
                this.fileChannel.write(this.buffer);
            }
            if (!this.keepFileChannelOpen) {
                this.fileChannel.close();
            }
            this.buffer.clear();
            this.allocator.clear();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public synchronized void flush() {
        if (this.isClosed()) {
            return;
        }
        this.writeCurrentBlockAndClear();
    }

    @Override
    public synchronized void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.writeCurrentBlockAndClear();
            this.free();
            this.writeHeader();
        }
    }

    @Override
    public synchronized LedStream<T> build() {
        if (this.closed.get()) {
            Logger.warn((String)("Trying to call build over a closed " + this.getClass().getSimpleName() + "..."));
            return LedStream.empty();
        }
        this.close();
        return new InputLedStream<T>(this.getInputStream(), this.factory, this.transactionSize).onClose(this::deleteTempFile);
    }

    private void writeHeader() {
        LedHeader header = new LedHeader();
        header.elementCount(this.numTransactions);
        header.elementSize(this.transactionSize);
        try (RandomAccessFile file = new RandomAccessFile(this.tempLedFile.toFile(), "rw");){
            file.writeLong(header.elementCount());
            file.writeInt(header.elementSize());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void deleteTempFile() {
        this.tempLedFile.toFile().delete();
        this.tempLedFile.toFile().deleteOnExit();
    }

    private void free() {
        try {
            this.allocator.free();
            this.allocator = null;
            this.buffer = null;
            this.fileChannel.close();
            this.fileChannel = null;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private InputStream getInputStream() {
        try {
            return Files.newInputStream(this.tempLedFile, new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

