/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.LedBuilder;
import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import io.intino.alexandria.led.leds.IteratorLedStream;
import io.intino.alexandria.led.leds.ListLed;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public interface Led<T extends Transaction>
extends Iterable<T> {
    public static <T extends Transaction> Led<T> empty() {
        return new ListLed(Collections.emptyList());
    }

    public static <T extends Transaction> Led<T> fromLedStream(LedStream<T> ledStream) {
        return new ListLed(ledStream.asJavaStream().collect(Collectors.toUnmodifiableList()));
    }

    public static <T extends Transaction> Builder<T> builder(Class<T> transactionClass) {
        return new LedBuilder<T>(transactionClass);
    }

    public static <T extends Transaction> Builder<T> builder(Class<T> transactionClass, TransactionFactory<T> factory) {
        return new LedBuilder<T>(transactionClass, factory);
    }

    public static <T extends Transaction> Builder<T> builder(Class<T> transactionClass, IndexedAllocator<T> allocator) {
        return new LedBuilder<T>(transactionClass, allocator);
    }

    public long size();

    public int transactionSize();

    public T transaction(int var1);

    @Override
    default public Iterator<T> iterator() {
        return this.elements().iterator();
    }

    default public List<T> elements() {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return Led.this.transaction(index);
            }

            @Override
            public int size() {
                return (int)Led.this.size();
            }
        };
    }

    default public LedStream<T> toLedStream() {
        return new IteratorLedStream<T>(this.transactionSize(), this.iterator());
    }

    public static interface Builder<T extends Transaction> {
        public Class<T> transactionClass();

        public int transactionSize();

        public Builder<T> create(Consumer<T> var1);

        public Led<T> build();
    }
}

