/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.LedReader;
import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.LedWriter;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.stack.SingleStackAllocator;
import io.intino.alexandria.led.allocators.stack.StackAllocator;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import io.intino.alexandria.led.util.memory.ModifiableMemoryAddress;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Stream;

public final class HeapLedStreamBuilder<T extends Transaction>
implements LedStream.Builder<T> {
    private static final int DEFAULT_NUM_TRANSACTIONS_PER_BLOCK = 5000000;
    private static final File SYSTEM_TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private final int transactionSize;
    private final Class<T> transactionClass;
    private final TransactionFactory<T> factory;
    private final List<Path> tempLeds;
    private final Path tempDirectory;
    private ByteBuffer buffer;
    private StackAllocator<T> allocator;
    private Queue<T> sortedQueue;
    private volatile boolean buildInvoked;

    public HeapLedStreamBuilder(Class<T> transactionClass) {
        this(transactionClass, Transaction.factoryOf(transactionClass));
    }

    public HeapLedStreamBuilder(Class<T> transactionClass, File tempDirectory) {
        this(transactionClass, Transaction.factoryOf(transactionClass), tempDirectory);
    }

    public HeapLedStreamBuilder(Class<T> transactionClass, int numTransactionsPerBlock) {
        this(transactionClass, Transaction.factoryOf(transactionClass), numTransactionsPerBlock);
    }

    public HeapLedStreamBuilder(Class<T> transactionClass, int numTransactionsPerBlock, File tempDirectory) {
        this(transactionClass, Transaction.factoryOf(transactionClass), numTransactionsPerBlock, tempDirectory);
    }

    public HeapLedStreamBuilder(Class<T> transactionClass, TransactionFactory<T> factory) {
        this(transactionClass, factory, 5000000);
    }

    public HeapLedStreamBuilder(Class<T> transactionClass, TransactionFactory<T> factory, File tempDirectory) {
        this(transactionClass, factory, 5000000, tempDirectory);
    }

    public HeapLedStreamBuilder(Class<T> transactionClass, TransactionFactory<T> factory, int numTransactionsPerBlock) {
        this(transactionClass, factory, numTransactionsPerBlock, SYSTEM_TEMP_DIR);
    }

    public HeapLedStreamBuilder(Class<T> transactionClass, TransactionFactory<T> factory, int numTransactionsPerBlock, File tempDirectory) {
        this.transactionClass = transactionClass;
        this.transactionSize = Transaction.sizeOf(transactionClass);
        this.factory = factory;
        tempDirectory.mkdirs();
        this.tempDirectory = tempDirectory.toPath();
        this.tempLeds = new ArrayList<Path>();
        this.tempLeds.add(this.createTempFile());
        this.buffer = MemoryUtils.allocBuffer(numTransactionsPerBlock * this.transactionSize);
        ModifiableMemoryAddress address = ModifiableMemoryAddress.of(this.buffer);
        ByteBufferStore store = new ByteBufferStore(this.buffer, address, 0, this.buffer.capacity());
        this.allocator = new SingleStackAllocator<T>(store, address, this.transactionSize, factory);
        this.sortedQueue = new PriorityQueue<T>(numTransactionsPerBlock);
    }

    public Path tempDirectory() {
        return this.tempDirectory;
    }

    private String getTempFilePrefix() {
        return this.transactionClass.getSimpleName();
    }

    @Override
    public Class<T> transactionClass() {
        return this.transactionClass;
    }

    @Override
    public int transactionSize() {
        return this.transactionSize;
    }

    @Override
    public LedStream.Builder<T> append(Consumer<T> initializer) {
        if (this.buildInvoked) {
            throw new IllegalStateException("Method build has been called, cannot create more transactions.");
        }
        T transaction = this.newTransaction();
        initializer.accept(transaction);
        this.sortedQueue.add(transaction);
        return this;
    }

    private T newTransaction() {
        if (this.allocator.remainingBytes() <= 0L) {
            this.writeCurrentBlockAndClear();
            this.tempLeds.add(this.createTempFile());
        }
        return this.allocator.calloc();
    }

    private Path createTempFile() {
        try {
            return Files.createTempFile(this.tempDirectory, this.getTempFilePrefix(), ".led.tmp", new FileAttribute[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void writeCurrentBlockAndClear() {
        if (this.allocator.stackPointer() == 0L) {
            return;
        }
        LedWriter ledWriter = new LedWriter(this.getCurrentFile().toFile());
        this.sortedQueue.iterator();
        ledWriter.write(LedStream.fromStream(this.transactionSize, this.getSortedTransactions()));
        this.sortedQueue.clear();
        this.buffer.clear();
        this.allocator.clear();
    }

    private Stream<T> getSortedTransactions() {
        return Stream.generate(() -> (Transaction)this.sortedQueue.poll()).takeWhile(Objects::nonNull);
    }

    private Path getCurrentFile() {
        return this.tempLeds.get(this.tempLeds.size() - 1);
    }

    @Override
    public LedStream<T> build() {
        if (this.buildInvoked) {
            throw new IllegalStateException("Method build has been already been called.");
        }
        this.writeCurrentBlockAndClear();
        this.freeBuildBuffer();
        this.buildInvoked = true;
        return this.mergeAllTempLeds();
    }

    private LedStream<T> mergeAllTempLeds() {
        return LedStream.merged(this.tempLeds.stream().map(this::read)).onClose(this::deleteAllTempFiles);
    }

    private void deleteAllTempFiles() {
        for (Path tempLedFile : this.tempLeds) {
            if (!Files.exists(tempLedFile, new LinkOption[0])) continue;
            tempLedFile.toFile().delete();
            tempLedFile.toFile().deleteOnExit();
        }
        this.tempLeds.clear();
    }

    private LedStream<T> read(Path path) {
        return new LedReader(path.toFile()).read(this.factory);
    }

    private void freeBuildBuffer() {
        this.allocator.free();
        this.buffer = null;
        this.allocator = null;
        this.sortedQueue.clear();
        this.sortedQueue = null;
    }
}

