/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.leds;

import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Transaction;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public class IteratorLedStream<T extends Transaction>
implements LedStream<T> {
    private final Iterator<T> iterator;
    private final int transactionSize;
    private Runnable onClose;

    public static <S extends Transaction> IteratorLedStream<S> fromStream(int transactionSize, Stream<S> stream) {
        return new IteratorLedStream(transactionSize, stream.sorted().iterator());
    }

    public IteratorLedStream(int transactionSize, Iterator<T> iterator) {
        this.iterator = Objects.requireNonNull(iterator);
        this.transactionSize = transactionSize;
    }

    @Override
    public void close() throws Exception {
        if (this.onClose != null) {
            this.onClose.run();
            this.onClose = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return (T)((Transaction)this.iterator.next());
    }

    @Override
    public LedStream<T> onClose(Runnable onClose) {
        this.onClose = onClose;
        return this;
    }

    @Override
    public int transactionSize() {
        return this.transactionSize;
    }
}

