/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.leds;

import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.stack.StackAllocator;
import io.intino.alexandria.led.allocators.stack.StackAllocators;
import io.intino.alexandria.led.util.MemoryUtils;
import io.intino.alexandria.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class InputLedStream<T extends Transaction>
implements LedStream<T> {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final InputStream inputStream;
    private final int bufferSize;
    private final int transactionSize;
    private final TransactionFactory<T> provider;
    private final Iterator<T> iterator;
    private Runnable onClose;
    private final AtomicBoolean closed;

    public InputLedStream(InputStream inputStream, Class<T> transactionClass) {
        this(inputStream, Transaction.factoryOf(transactionClass), Transaction.sizeOf(transactionClass), 4096);
    }

    public InputLedStream(InputStream inputStream, Class<T> transactionClass, int bufferSize) {
        this(inputStream, Transaction.factoryOf(transactionClass), Transaction.sizeOf(transactionClass), bufferSize);
    }

    public InputLedStream(InputStream inputStream, TransactionFactory<T> factory, int transactionSize) {
        this(inputStream, factory, transactionSize, 4096);
    }

    public InputLedStream(InputStream inputStream, TransactionFactory<T> factory, int transactionSize, int bufferSize) {
        this.inputStream = inputStream;
        this.transactionSize = transactionSize;
        this.provider = factory;
        this.iterator = this.stream().iterator();
        this.bufferSize = bufferSize;
        this.closed = new AtomicBoolean();
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return (T)((Transaction)this.iterator.next());
    }

    @Override
    public LedStream<T> onClose(Runnable onClose) {
        this.onClose = onClose;
        return this;
    }

    public synchronized Stream<T> stream() {
        return Stream.generate(() -> this.read(this.inputStream)).takeWhile(inputBuffer -> this.checkInputBuffer((ByteBuffer)inputBuffer, this.inputStream)).flatMap(this::allocateAll);
    }

    @Override
    public int transactionSize() {
        return this.transactionSize;
    }

    private boolean checkInputBuffer(ByteBuffer inputBuffer, InputStream inputStream) {
        if (inputBuffer != null) {
            return true;
        }
        this.closeInputStream(inputStream);
        return false;
    }

    private synchronized void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private Stream<T> allocateAll(ByteBuffer bytes) {
        StackAllocator allocator = StackAllocators.newManaged(this.transactionSize, bytes, this.provider);
        return IntStream.range(0, bytes.remaining() / this.transactionSize).sorted().parallel().mapToObj((int index) -> allocator.malloc());
    }

    private synchronized ByteBuffer read(InputStream inputStream) {
        try {
            if (inputStream == null || inputStream.available() <= 0) {
                return null;
            }
            byte[] inputBuffer = new byte[this.bufferSize * this.transactionSize];
            int bytesRead = inputStream.read(inputBuffer);
            if (bytesRead < 0) {
                return null;
            }
            ByteBuffer buffer = MemoryUtils.allocBuffer(bytesRead);
            buffer.put(inputBuffer, 0, bytesRead);
            buffer.clear();
            return buffer;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.closed.get()) {
            return;
        }
        if (this.onClose != null) {
            this.onClose.run();
            this.onClose = null;
        }
        this.inputStream.close();
        this.closed.set(true);
    }
}

