/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.buffers.store;

import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.buffers.store.NativePointerStore;
import io.intino.alexandria.led.util.MemoryAddress;
import io.intino.alexandria.led.util.MemoryUtils;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ByteBufferStore
implements ByteStore {
    private final ByteBuffer buffer;
    private final MemoryAddress address;
    private final int baseOffset;
    private final int size;

    public ByteBufferStore(ByteBuffer buffer, MemoryAddress address, int baseOffset, int size) {
        this.buffer = Objects.requireNonNull(buffer);
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Buffer is not direct");
        }
        this.address = address;
        if (Integer.toUnsignedLong(baseOffset) != (long)baseOffset) {
            throw new IllegalArgumentException("Base offset is negative or is too large for ByteBufferStore. Use " + NativePointerStore.class.getSimpleName() + " instead");
        }
        if (Integer.toUnsignedLong(size) != (long)size) {
            throw new IllegalArgumentException("Size is negative or is too large for ByteBufferStore. Use " + NativePointerStore.class.getSimpleName() + " instead");
        }
        this.baseOffset = baseOffset;
        this.size = size;
    }

    @Override
    public long address() {
        return this.address.get();
    }

    @Override
    public ByteBuffer storeImpl() {
        return this.buffer;
    }

    @Override
    public long baseOffset() {
        return this.baseOffset;
    }

    @Override
    public long byteSize() {
        return this.size;
    }

    @Override
    public byte getByte(int byteIndex) {
        return this.buffer.get(byteIndex + this.baseOffset);
    }

    @Override
    public void setByte(int byteIndex, byte value) {
        this.buffer.put(byteIndex + this.baseOffset, value);
    }

    @Override
    public short getShort(int byteIndex) {
        return this.buffer.getShort(byteIndex + this.baseOffset);
    }

    @Override
    public void setShort(int byteIndex, short value) {
        this.buffer.putShort(byteIndex + this.baseOffset, value);
    }

    @Override
    public char getChar(int byteIndex) {
        return this.buffer.getChar(byteIndex + this.baseOffset);
    }

    @Override
    public void setChar(int byteIndex, char value) {
        this.buffer.putChar(byteIndex + this.baseOffset, value);
    }

    @Override
    public int getInt(int byteIndex) {
        return this.buffer.getInt(byteIndex + this.baseOffset);
    }

    @Override
    public void setInt(int byteIndex, int value) {
        this.buffer.putInt(byteIndex + this.baseOffset, value);
    }

    @Override
    public long getLong(int byteIndex) {
        return this.buffer.getLong(byteIndex + this.baseOffset);
    }

    @Override
    public void setLong(int byteIndex, long value) {
        this.buffer.putLong(byteIndex + this.baseOffset, value);
    }

    @Override
    public float getFloat(int byteIndex) {
        return this.buffer.getFloat(byteIndex + this.baseOffset);
    }

    @Override
    public void setFloat(int byteIndex, float value) {
        this.buffer.putFloat(byteIndex + this.baseOffset, value);
    }

    @Override
    public double getDouble(int byteIndex) {
        return this.buffer.getDouble(byteIndex + this.baseOffset);
    }

    @Override
    public void setDouble(int byteIndex, double value) {
        this.buffer.putDouble(byteIndex + this.baseOffset, value);
    }

    @Override
    public void clear() {
        MemoryUtils.memset(this.address() + (long)this.baseOffset, this.size, 0);
    }

    @Override
    public ByteStore slice(long offset, long size) {
        if (offset + (long)this.baseOffset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Offset too large for ByteBufferStore");
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size too large for ByteBufferStore");
        }
        return new ByteBufferStore(this.buffer, this.address, this.baseOffset + (int)offset, (int)size);
    }
}

