/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.allocators.indexed;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import io.intino.alexandria.led.buffers.store.NativePointerStore;
import io.intino.alexandria.led.util.MemoryUtils;
import io.intino.alexandria.led.util.ModifiableMemoryAddress;
import io.intino.alexandria.led.util.NativePointerCleaner;
import java.lang.ref.Cleaner;

public class UnmanagedIndexedAllocator<T extends Transaction>
implements IndexedAllocator<T> {
    private static final Cleaner CLEANER = Cleaner.create();
    private NativePointerStore store;
    private final ModifiableMemoryAddress address;
    private final int elementSize;
    private final TransactionFactory<T> factory;
    private final Cleaner.Cleanable cleanable;

    public UnmanagedIndexedAllocator(long baseAddress, long baseOffset, long size, int elementSize, TransactionFactory<T> factory) {
        this.elementSize = elementSize;
        this.factory = factory;
        this.address = new ModifiableMemoryAddress(baseAddress);
        this.store = new NativePointerStore(this.address, baseOffset, size);
        this.cleanable = CLEANER.register(this, new NativePointerCleaner(this.address));
    }

    public UnmanagedIndexedAllocator(long elementsCount, int elementSize, TransactionFactory<T> factory) {
        this.elementSize = elementSize;
        this.factory = factory;
        long size = elementsCount * (long)elementSize;
        this.address = new ModifiableMemoryAddress(MemoryUtils.malloc(size));
        this.store = new NativePointerStore(this.address, 0L, size);
        this.cleanable = CLEANER.register(this, new NativePointerCleaner(this.address));
    }

    @Override
    public T malloc(int index) {
        int offset = index * this.elementSize;
        return (T)((Transaction)this.factory.newInstance(this.store.slice(offset, this.elementSize)));
    }

    @Override
    public T calloc(int index) {
        T instance = this.malloc(index);
        ((Transaction)instance).clear();
        return instance;
    }

    @Override
    public void clear(int index) {
        MemoryUtils.memset(this.address.get() + (long)(index * this.elementSize), this.elementSize, 0);
    }

    @Override
    public long byteSize() {
        return this.store.byteSize();
    }

    @Override
    public long size() {
        return this.byteSize() / (long)this.elementSize;
    }

    @Override
    public T malloc() {
        return this.malloc(0);
    }

    @Override
    public T calloc() {
        return this.calloc(0);
    }

    @Override
    public int transactionSize() {
        return this.elementSize;
    }

    @Override
    public void clear() {
    }

    @Override
    public void free() {
        if (this.address.get() != 0L) {
            this.cleanable.clean();
            this.store = null;
        }
    }
}

