/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.buffers.BigEndianBitBuffer;
import io.intino.alexandria.led.buffers.BitBuffer;
import io.intino.alexandria.led.buffers.LittleEndianBitBuffer;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.MemoryUtils;
import io.intino.alexandria.led.util.OffHeapObject;
import io.intino.alexandria.logger.Logger;
import java.lang.reflect.Constructor;
import java.nio.ByteOrder;
import java.util.Objects;

public abstract class Transaction
implements OffHeapObject,
Comparable<Transaction> {
    protected final BitBuffer bitBuffer;

    public static long idOf(Transaction transaction) {
        return MemoryUtils.getLong(transaction.address(), transaction.baseOffset());
    }

    public static <T extends Transaction> int sizeOf(Class<T> type) {
        try {
            return (Integer)type.getField("SIZE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Logger.error((Throwable)e);
            return -1;
        }
    }

    public static <T extends Transaction> TransactionFactory<T> factoryOf(Class<T> type) {
        try {
            Constructor constructor = type.getConstructor(ByteStore.class);
            return store -> {
                try {
                    return (Transaction)constructor.newInstance(store);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            Logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Transaction(ByteStore store) {
        this.bitBuffer = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? new LittleEndianBitBuffer(store) : new BigEndianBitBuffer(store);
    }

    protected abstract long id();

    public abstract int size();

    public int hashCode() {
        return Objects.hashCode(this.id());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Transaction other = (Transaction)obj;
        return this.notNull() && other.notNull() && this.id() == other.id();
    }

    public boolean isReadOnly() {
        return this.bitBuffer.isReadOnly();
    }

    @Override
    public boolean isNull() {
        return this.bitBuffer.isNull();
    }

    @Override
    public boolean notNull() {
        return this.bitBuffer.notNull();
    }

    @Override
    public int compareTo(Transaction o) {
        return Long.compare(this.id(), o.id());
    }

    public void clear() {
        this.bitBuffer.clear();
    }

    @Override
    public long address() {
        return this.bitBuffer.address();
    }

    @Override
    public long byteSize() {
        return this.bitBuffer.byteSize();
    }

    @Override
    public long baseOffset() {
        return this.bitBuffer.baseOffset();
    }

    public void invalidate() {
        this.bitBuffer.invalidate();
    }

    public long bitCount() {
        return this.bitBuffer.bitCount();
    }

    public long endOffset() {
        return this.bitBuffer.endOffset();
    }

    public String toBinaryString() {
        return this.bitBuffer.toBinaryString();
    }

    public String toBinaryString(int splitSize) {
        return this.bitBuffer.toBinaryString(splitSize);
    }

    public String toHexString() {
        return this.bitBuffer.toHexString();
    }
}

