/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.LedReader;
import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.LedWriter;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.stack.SingleStackAllocator;
import io.intino.alexandria.led.allocators.stack.StackAllocator;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.util.MemoryUtils;
import io.intino.alexandria.led.util.ModifiableMemoryAddress;
import io.intino.alexandria.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Consumer;

public final class LedStreamBuilder<T extends Transaction>
implements LedStream.Builder<T> {
    private static final int DEFAULT_NUM_TRANSACTIONS_PER_BLOCK = 5000000;
    private static final Path SYSTEM_TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private final int transactionSize;
    private final Class<T> transactionClass;
    private final TransactionFactory<T> factory;
    private final List<Path> tempLeds;
    private ByteBuffer buffer;
    private StackAllocator<T> allocator;
    private Queue<T> sortedQueue;
    private volatile boolean buildInvoked;

    public LedStreamBuilder(Class<T> transactionClass) {
        this(transactionClass, Transaction.factoryOf(transactionClass));
    }

    public LedStreamBuilder(Class<T> transactionClass, int numTransactionsPerBlock) {
        this(transactionClass, Transaction.factoryOf(transactionClass), numTransactionsPerBlock);
    }

    public LedStreamBuilder(Class<T> transactionClass, TransactionFactory<T> factory) {
        this(transactionClass, factory, 5000000);
    }

    public LedStreamBuilder(Class<T> transactionClass, TransactionFactory<T> factory, int numTransactionsPerBlock) {
        this.transactionClass = transactionClass;
        this.transactionSize = Transaction.sizeOf(transactionClass);
        this.factory = factory;
        this.tempLeds = new ArrayList<Path>();
        this.tempLeds.add(this.createTempFile());
        this.buffer = MemoryUtils.allocBuffer(numTransactionsPerBlock * this.transactionSize);
        ModifiableMemoryAddress address = ModifiableMemoryAddress.of(this.buffer);
        ByteBufferStore store = new ByteBufferStore(this.buffer, address, 0, this.buffer.capacity());
        this.allocator = new SingleStackAllocator<T>(store, address, this.transactionSize, factory);
        this.sortedQueue = new PriorityQueue<T>(numTransactionsPerBlock);
    }

    private String getTempFilePrefix() {
        return this.getClass().getSimpleName() + "." + this.transactionClass.getSimpleName();
    }

    @Override
    public Class<T> transactionClass() {
        return this.transactionClass;
    }

    @Override
    public int transactionSize() {
        return this.transactionSize;
    }

    @Override
    public LedStream.Builder<T> create(Consumer<T> initializer) {
        if (this.buildInvoked) {
            throw new IllegalStateException("Method build has been called, cannot create more transactions.");
        }
        T transaction = this.newTransaction();
        initializer.accept(transaction);
        this.sortedQueue.add(transaction);
        return this;
    }

    private T newTransaction() {
        if (this.allocator.remainingBytes() <= 0L) {
            this.writeCurrentBlockAndClear();
            this.tempLeds.add(this.createTempFile());
        }
        return this.allocator.calloc();
    }

    private Path createTempFile() {
        try {
            return Files.createTempFile(SYSTEM_TEMP_DIR, this.getTempFilePrefix(), ".tmp", new FileAttribute[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void writeCurrentBlockAndClear() {
        if (this.allocator.stackPointer() == 0L) {
            return;
        }
        LedWriter ledWriter = new LedWriter(this.getCurrentFile().toFile());
        ledWriter.write(LedStream.fromStream(this.transactionSize, this.sortedQueue.stream()));
        this.sortedQueue.clear();
        this.buffer.clear();
        this.allocator.clear();
    }

    private Path getCurrentFile() {
        return this.tempLeds.get(this.tempLeds.size() - 1);
    }

    @Override
    public LedStream<T> build() {
        if (this.buildInvoked) {
            throw new IllegalStateException("Method build has been already been called.");
        }
        this.writeCurrentBlockAndClear();
        this.freeBuildBuffer();
        this.buildInvoked = true;
        return this.mergeAllTempLeds();
    }

    private LedStream<T> mergeAllTempLeds() {
        return LedStream.merged(this.tempLeds.stream().map(this::read)).onClose(this::deleteAllTempFiles);
    }

    private void deleteAllTempFiles() {
        for (Path tempLedFile : this.tempLeds) {
            try {
                Files.delete(tempLedFile);
                tempLedFile.toFile().delete();
                tempLedFile.toFile().deleteOnExit();
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
        this.tempLeds.clear();
    }

    private LedStream<T> read(Path path) {
        return new LedReader(path.toFile()).read(this.factory);
    }

    private InputStream createInputStream(Path path) {
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void freeBuildBuffer() {
        this.allocator.free();
        this.buffer = null;
        this.allocator = null;
        this.sortedQueue.clear();
        this.sortedQueue = null;
    }
}

