/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util;

import org.apache.commons.lang3.StringUtils;

public final class BitUtils {
    public static long read(long n, int offset, int bitCount) {
        return n >> offset & BitUtils.ones(bitCount);
    }

    public static long write(long n, long value, int offset, int bitCount) {
        return n & BitUtils.zeros(bitCount, offset) | value << offset;
    }

    public static long bitmask(int shift) {
        return shift == 64 ? -1L : 1L << shift;
    }

    public static long ones(int shift) {
        long bitmask = BitUtils.bitmask(shift);
        return bitmask == -1L ? bitmask : bitmask - 1L;
    }

    public static long ones(int n, int shift) {
        return BitUtils.ones(n) << shift;
    }

    public static long zeros(int n, int shift) {
        return BitUtils.ones(n, shift) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static String toBinaryString(long value, int padding) {
        return StringUtils.leftPad((String)Long.toBinaryString(value), (int)padding, (char)'0');
    }

    public static int byteIndex(int bitIndex) {
        return bitIndex / 8;
    }

    public static int bitIndex(int byteIndex) {
        return byteIndex * 8;
    }

    public static int offsetOf(int bitIndex) {
        return bitIndex % 8;
    }

    public static int roundUp2(int n, int multiple) {
        return n + multiple - 1 & -multiple;
    }

    public static int bitsUsed(long value) {
        return 64 - Long.numberOfLeadingZeros(value);
    }

    public static double maxPossibleNumber(int numberOfBits) {
        return Math.pow(2.0, numberOfBits) / 2.0 - 1.0;
    }

    public static int getMinimumBytesForBits(int bitIndex, int bitCount) {
        int bitOffset = BitUtils.offsetOf(bitIndex);
        int numBytes = (bitOffset + bitCount) / 8 + 1;
        return BitUtils.roundToJavaPrimitiveSize(numBytes);
    }

    public static int roundToJavaPrimitiveSize(int n) {
        if (n == 1 || n == 2 || n == 4 || n == 8) {
            return n;
        }
        if (n < 4) {
            return 4;
        }
        return 8;
    }

    public static String toBinaryString(long value, int padding, int splitSize) {
        String str = BitUtils.toBinaryString(value, padding);
        if (splitSize == 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        int offset = splitSize;
        for (int i = 0; i < str.length() / splitSize; ++i) {
            sb.insert(offset, ' ');
            offset += splitSize + 1;
        }
        return sb.toString();
    }

    private BitUtils() {
    }
}

