/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.leds;

import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.indexed.ListAllocator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DynamicLed<S extends Transaction>
implements Led<S> {
    private final ListAllocator<S> allocator;
    private final int transactionSize;

    public DynamicLed(int schemaSize, TransactionFactory<S> factory) {
        this.transactionSize = schemaSize;
        this.allocator = new ListAllocator<S>(1000L, schemaSize, factory);
    }

    public Transaction newTransaction() {
        return this.allocator.malloc();
    }

    @Override
    public long size() {
        return this.allocator.size();
    }

    @Override
    public int transactionSize() {
        return this.transactionSize;
    }

    @Override
    public S transaction(int index) {
        if ((long)index >= this.size()) {
            throw new IndexOutOfBoundsException("Index >= " + this.size());
        }
        return this.allocator.malloc(index);
    }

    @Override
    public Iterator<S> iterator() {
        return this.elements().iterator();
    }

    @Override
    public List<S> elements() {
        return this.stream().collect(Collectors.toList());
    }

    private Stream<S> stream() {
        return IntStream.range(0, (int)this.size()).mapToObj(this.allocator::malloc);
    }
}

