/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.buffers.store;

import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.MemoryAddress;
import io.intino.alexandria.led.util.MemoryUtils;

public class NativePointerStore
implements ByteStore {
    private final MemoryAddress address;
    private final long baseOffset;
    private final long size;

    public NativePointerStore(MemoryAddress address, long baseOffset, long size) {
        this.address = address;
        this.size = size;
        if (size < 0L) {
            throw new IllegalArgumentException("Size is negative or is too large");
        }
        this.baseOffset = baseOffset;
        if (baseOffset < 0L) {
            throw new IllegalArgumentException("Base offset is negative or is too large");
        }
    }

    @Override
    public long address() {
        return this.address.get();
    }

    @Override
    public long byteSize() {
        return this.size;
    }

    @Override
    public Long storeImpl() {
        return this.address.get();
    }

    @Override
    public long baseOffset() {
        return this.baseOffset;
    }

    @Override
    public byte getByte(int byteIndex) {
        return MemoryUtils.getByte(this.address.get(), (long)byteIndex + this.baseOffset);
    }

    @Override
    public void setByte(int byteIndex, byte value) {
        MemoryUtils.setByte(this.address.get(), (long)byteIndex + this.baseOffset, value);
    }

    @Override
    public short getShort(int byteIndex) {
        return MemoryUtils.getShort(this.address.get(), (long)byteIndex + this.baseOffset);
    }

    @Override
    public void setShort(int byteIndex, short value) {
        MemoryUtils.setShort(this.address.get(), (long)byteIndex + this.baseOffset, value);
    }

    @Override
    public char getChar(int byteIndex) {
        return MemoryUtils.getChar(this.address.get(), (long)byteIndex + this.baseOffset);
    }

    @Override
    public void setChar(int byteIndex, char value) {
        MemoryUtils.setChar(this.address.get(), (long)byteIndex + this.baseOffset, value);
    }

    @Override
    public int getInt(int byteIndex) {
        return MemoryUtils.getInt(this.address.get(), (long)byteIndex + this.baseOffset);
    }

    @Override
    public void setInt(int byteIndex, int value) {
        MemoryUtils.setInt(this.address.get(), (long)byteIndex + this.baseOffset, value);
    }

    @Override
    public long getLong(int byteIndex) {
        return MemoryUtils.getLong(this.address.get(), (long)byteIndex + this.baseOffset);
    }

    @Override
    public void setLong(int byteIndex, long value) {
        MemoryUtils.setLong(this.address.get(), (long)byteIndex + this.baseOffset, value);
    }

    @Override
    public float getFloat(int byteIndex) {
        return MemoryUtils.getFloat(this.address.get(), (long)byteIndex + this.baseOffset);
    }

    @Override
    public void setFloat(int byteIndex, float value) {
        MemoryUtils.setFloat(this.address.get(), (long)byteIndex + this.baseOffset, value);
    }

    @Override
    public double getDouble(int byteIndex) {
        return MemoryUtils.getDouble(this.address.get(), (long)byteIndex + this.baseOffset);
    }

    @Override
    public void setDouble(int byteIndex, double value) {
        MemoryUtils.setDouble(this.address.get(), (long)byteIndex + this.baseOffset, value);
    }

    @Override
    public void clear() {
        MemoryUtils.memset(this.address() + this.baseOffset, this.size, 0);
    }

    @Override
    public ByteStore slice(long baseOffset, long size) {
        return new NativePointerStore(this.address, this.baseOffset + baseOffset, size);
    }
}

