/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.buffers;

import io.intino.alexandria.led.buffers.AbstractBitBuffer;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.BitUtils;

public class LittleEndianBitBuffer
extends AbstractBitBuffer {
    public LittleEndianBitBuffer(ByteStore store) {
        super(store);
    }

    @Override
    protected AbstractBitBuffer.BitInfo computeBitInfo(int bitIndex, int bitCount) {
        int byteIndex = BitUtils.byteIndex(bitIndex);
        int numBytes = BitUtils.getMinimumBytesForBits(bitIndex, bitCount);
        int additionalBytes = (int)Math.abs(Math.min(this.byteSize() - (long)byteIndex - (long)numBytes, 0L));
        int bitOffset = BitUtils.offsetOf(bitIndex) + additionalBytes * 8;
        return new AbstractBitBuffer.BitInfo(byteIndex -= additionalBytes, numBytes, bitOffset);
    }
}

