/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.buffers;

import io.intino.alexandria.led.buffers.BitBuffer;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.buffers.store.ReadOnlyByteStore;
import io.intino.alexandria.led.util.BitUtils;
import java.util.Objects;

public abstract class AbstractBitBuffer
implements BitBuffer {
    private ByteStore store;

    public AbstractBitBuffer(ByteStore store) {
        this.store = Objects.requireNonNull(store);
    }

    @Override
    public final long address() {
        return this.store.address();
    }

    @Override
    public void invalidate() {
        if (!this.isReadOnly()) {
            this.store = new ReadOnlyByteStore(this.store);
        }
    }

    @Override
    public long byteSize() {
        return this.store.byteSize();
    }

    @Override
    public final long bitCount() {
        return this.store.bitCount();
    }

    @Override
    public long baseOffset() {
        return this.store.baseOffset();
    }

    @Override
    public long endOffset() {
        return this.baseOffset() + this.byteSize();
    }

    protected abstract BitInfo computeBitInfo(int var1, int var2);

    @Override
    public byte getByteNBits(int bitIndex, int bitCount) {
        return (byte)this.getNBits(bitIndex, bitCount, this.computeBitInfo(bitIndex, bitCount));
    }

    @Override
    public short getShortNBits(int bitIndex, int bitCount) {
        return (short)this.getNBits(bitIndex, bitCount, this.computeBitInfo(bitIndex, bitCount));
    }

    @Override
    public int getIntegerNBits(int bitIndex, int bitCount) {
        return (int)this.getNBits(bitIndex, bitCount, this.computeBitInfo(bitIndex, bitCount));
    }

    @Override
    public long getLongNBits(int bitIndex, int bitCount) {
        return this.getNBits(bitIndex, bitCount, this.computeBitInfo(bitIndex, bitCount));
    }

    private long getNBits(int bitIndex, int bitCount, BitInfo bitInfo) {
        long value;
        switch (bitInfo.numBytes) {
            case 1: {
                value = this.getAlignedByte(bitIndex);
                value &= 0xFFL;
                break;
            }
            case 2: {
                value = this.getAlignedShort(bitIndex);
                value &= 0xFFFFL;
                break;
            }
            case 4: {
                value = this.getAlignedInteger(bitIndex);
                value &= 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 8: {
                value = this.getAlignedLong(bitIndex);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported number of bits " + bitCount);
            }
        }
        return BitUtils.read(value, bitInfo.bitOffset, bitCount);
    }

    @Override
    public float getReal32Bits(int bitIndex) {
        BitInfo bitInfo = this.computeBitInfo(bitIndex, 32);
        int bits = (int)BitUtils.read(this.store.getInt(bitInfo.byteIndex), bitInfo.bitOffset, 32);
        return Float.intBitsToFloat(bits);
    }

    @Override
    public double getReal64Bits(int bitIndex) {
        BitInfo bitInfo = this.computeBitInfo(bitIndex, 64);
        long bits = BitUtils.read(this.store.getLong(bitInfo.byteIndex), bitInfo.bitOffset, 64);
        return Double.longBitsToDouble(bits);
    }

    @Override
    public void setByteNBits(int bitIndex, int bitCount, byte value) {
        this.setNBits(bitIndex, bitCount, value, this.computeBitInfo(bitIndex, bitCount));
    }

    @Override
    public void setShortNBits(int bitIndex, int bitCount, short value) {
        this.setNBits(bitIndex, bitCount, value, this.computeBitInfo(bitIndex, bitCount));
    }

    @Override
    public void setIntegerNBits(int bitIndex, int bitCount, int value) {
        this.setNBits(bitIndex, bitCount, value, this.computeBitInfo(bitIndex, bitCount));
    }

    @Override
    public void setLongNBits(int bitIndex, int bitCount, long value) {
        this.setNBits(bitIndex, bitCount, value, this.computeBitInfo(bitIndex, bitCount));
    }

    private void setNBits(int bitIndex, int bitCount, long value, BitInfo bitInfo) {
        switch (bitInfo.numBytes) {
            case 1: {
                this.setInt8(bitIndex, bitInfo.byteIndex, bitInfo.bitOffset, bitCount, value);
                break;
            }
            case 2: {
                this.setInt16(bitIndex, bitInfo.byteIndex, bitInfo.bitOffset, bitCount, value);
                break;
            }
            case 4: {
                this.setInt32(bitIndex, bitInfo.byteIndex, bitInfo.bitOffset, bitCount, value);
                break;
            }
            case 8: {
                this.setInt64(bitIndex, bitInfo.byteIndex, bitInfo.bitOffset, bitCount, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported number of bits " + bitCount);
            }
        }
    }

    private void setInt8(int bitIndex, int byteIndex, int bitOffset, int bitCount, long value) {
        byte oldValue = this.getAlignedByte(bitIndex);
        byte newValue = (byte)BitUtils.write(oldValue, (byte)value, bitOffset, bitCount);
        this.store.setByte(byteIndex, newValue);
    }

    private void setInt16(int bitIndex, int byteIndex, int bitOffset, int bitCount, long value) {
        short oldValue = this.getAlignedShort(bitIndex);
        short newValue = (short)BitUtils.write(oldValue, (short)value, bitOffset, bitCount);
        this.store.setShort(byteIndex, newValue);
    }

    private void setInt32(int bitIndex, int byteIndex, int bitOffset, int bitCount, long value) {
        int oldValue = this.getAlignedInteger(bitIndex);
        int newValue = (int)BitUtils.write(oldValue, (int)value, bitOffset, bitCount);
        this.store.setInt(byteIndex, newValue);
    }

    private void setInt64(int bitIndex, int byteIndex, int bitOffset, int bitCount, long value) {
        long oldValue = this.getAlignedLong(bitIndex);
        long newValue = BitUtils.write(oldValue, value, bitOffset, bitCount);
        this.store.setLong(byteIndex, newValue);
    }

    @Override
    public void setReal32Bits(int bitIndex, float value) {
        BitInfo bitInfo = this.computeBitInfo(bitIndex, 32);
        int bits = Float.floatToIntBits(value);
        int newValue = (int)BitUtils.write(0L, bits, bitInfo.bitOffset, 32);
        if (bitInfo.numBytes == 32) {
            this.store.setInt(bitInfo.byteIndex, newValue);
        } else {
            this.store.setLong(bitInfo.byteIndex, newValue);
        }
    }

    @Override
    public void setReal64Bits(int bitIndex, double value) {
        BitInfo bitInfo = this.computeBitInfo(bitIndex, 64);
        long bits = Double.doubleToLongBits(value);
        long newValue = BitUtils.write(0L, bits, bitInfo.bitOffset, 64);
        this.store.setLong(bitInfo.byteIndex, newValue);
    }

    @Override
    public byte getAlignedByte(int bitIndex) {
        return this.store.getByte(BitUtils.byteIndex(bitIndex));
    }

    @Override
    public short getAlignedShort(int bitIndex) {
        return this.store.getShort(BitUtils.byteIndex(bitIndex));
    }

    @Override
    public char getAlignedChar(int bitIndex) {
        return this.store.getChar(BitUtils.byteIndex(bitIndex));
    }

    @Override
    public int getAlignedInteger(int bitIndex) {
        return this.store.getInt(BitUtils.byteIndex(bitIndex));
    }

    @Override
    public long getAlignedLong(int bitIndex) {
        return this.store.getLong(BitUtils.byteIndex(bitIndex));
    }

    @Override
    public float getAlignedReal32Bits(int bitIndex) {
        return this.store.getFloat(BitUtils.byteIndex(bitIndex));
    }

    @Override
    public double getAlignedReal64Bits(int bitIndex) {
        return this.store.getDouble(BitUtils.byteIndex(bitIndex));
    }

    @Override
    public void setAlignedByte(int bitIndex, byte value) {
        this.store.setByte(BitUtils.byteIndex(bitIndex), value);
    }

    @Override
    public void setAlignedShort(int bitIndex, short value) {
        this.store.setShort(BitUtils.byteIndex(bitIndex), value);
    }

    @Override
    public void setAlignedChar(int bitIndex, char value) {
        this.store.setChar(BitUtils.byteIndex(bitIndex), value);
    }

    @Override
    public void setAlignedInteger(int bitIndex, int value) {
        this.store.setInt(BitUtils.byteIndex(bitIndex), value);
    }

    @Override
    public void setAlignedLong(int bitIndex, long value) {
        this.store.setLong(BitUtils.byteIndex(bitIndex), value);
    }

    @Override
    public void setAlignedReal32Bits(int bitIndex, float value) {
        this.store.setFloat(BitUtils.byteIndex(bitIndex), value);
    }

    @Override
    public void setAlignedReal64Bits(int bitIndex, double value) {
        this.store.setDouble(BitUtils.byteIndex(bitIndex), value);
    }

    @Override
    public final void clear() {
        this.store.clear();
    }

    @Override
    public String toBinaryString() {
        return this.toBinaryString(0);
    }

    @Override
    public String toBinaryString(int splitSize) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((long)i < this.byteSize()) {
            sb.append(BitUtils.toBinaryString(this.store.getByte(i) & 0xFF, 8, splitSize));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String toHexString() {
        StringBuilder sb = new StringBuilder();
        for (int i = (int)(this.endOffset() - 1L); i >= 0; --i) {
            sb.insert(0, String.format("%02X", this.store.getByte(i) & 0xFF));
        }
        return "0x" + sb.toString();
    }

    @Override
    public String toString() {
        return this.toHexString();
    }

    @Override
    public boolean isReadOnly() {
        return this.store instanceof ReadOnlyByteStore;
    }

    protected final class BitInfo {
        private final int byteIndex;
        private final int numBytes;
        private final int bitOffset;

        public BitInfo(int byteIndex, int numBytes, int bitOffset) {
            this.byteIndex = byteIndex;
            this.numBytes = numBytes;
            this.bitOffset = bitOffset;
        }
    }
}

