/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.buffers.BigEndianBitBuffer;
import io.intino.alexandria.led.buffers.BitBuffer;
import io.intino.alexandria.led.buffers.LittleEndianBitBuffer;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.OffHeapObject;
import java.nio.ByteOrder;
import java.util.Objects;

public abstract class Transaction
implements OffHeapObject,
Comparable<Transaction> {
    protected final BitBuffer bitBuffer;

    public Transaction(ByteStore store) {
        this.bitBuffer = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? new LittleEndianBitBuffer(store) : new BigEndianBitBuffer(store);
    }

    public abstract long id();

    public abstract int size();

    public int hashCode() {
        return Objects.hashCode(this.id());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Transaction other = (Transaction)obj;
        return this.notNull() && other.notNull() && this.id() == other.id();
    }

    public boolean isReadOnly() {
        return this.bitBuffer.isReadOnly();
    }

    @Override
    public boolean isNull() {
        return this.bitBuffer.isNull();
    }

    @Override
    public boolean notNull() {
        return this.bitBuffer.notNull();
    }

    @Override
    public int compareTo(Transaction o) {
        return Long.compare(this.id(), o.id());
    }

    public void clear() {
        this.bitBuffer.clear();
    }

    @Override
    public long address() {
        return this.bitBuffer.address();
    }

    @Override
    public long byteSize() {
        return this.bitBuffer.byteSize();
    }

    @Override
    public long baseOffset() {
        return this.bitBuffer.baseOffset();
    }

    public void invalidate() {
        this.bitBuffer.invalidate();
    }

    public long bitCount() {
        return this.bitBuffer.bitCount();
    }

    public long endOffset() {
        return this.bitBuffer.endOffset();
    }

    public String toBinaryString() {
        return this.bitBuffer.toBinaryString();
    }

    public String toBinaryString(int splitSize) {
        return this.bitBuffer.toBinaryString(splitSize);
    }

    public String toHexString() {
        return this.bitBuffer.toHexString();
    }
}

