/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.LedHeader;
import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.util.MemoryUtils;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.xerial.snappy.SnappyOutputStream;

public class LedWriter {
    private final int bufferSize = 1024;
    private final OutputStream destination;
    private final File destinationFile;

    public LedWriter(File destination) {
        destination.getAbsoluteFile().getParentFile().mkdirs();
        this.destinationFile = destination;
        this.destination = this.outputStream(destination);
    }

    public LedWriter(OutputStream destination) {
        this.destination = destination;
        this.destinationFile = null;
    }

    public FileOutputStream outputStream(File destination) {
        try {
            return new FileOutputStream(destination);
        }
        catch (FileNotFoundException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public void write(Led<? extends Transaction> led) {
        this.serialize(led);
    }

    public void write(LedStream<? extends Transaction> led) {
        this.serialize(led);
    }

    private void serialize(Led<? extends Transaction> led) {
        if (led.size() == 0L) {
            return;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        long size = led.size();
        int transactionSize = led.transactionSize();
        int numBatches = (int)Math.ceil((float)led.size() / 1024.0f);
        List<? extends Transaction> elements = led.elements();
        try (OutputStream fos = this.destination;){
            LedHeader header = new LedHeader();
            header.elementCount(size).elementSize(transactionSize);
            fos.write(header.toByteArray());
            try (SnappyOutputStream outputStream = new SnappyOutputStream(fos);){
                for (int i = 0; i < numBatches; ++i) {
                    int start = i * 1024;
                    int numElements = (int)Math.min(1024L, led.size() - (long)start);
                    byte[] outputBuffer = new byte[numElements * transactionSize];
                    for (int j = 0; j < numElements; ++j) {
                        Transaction src = elements.get(j + start);
                        long offset = j * transactionSize;
                        MemoryUtils.memcpy(src.address(), src.baseOffset(), outputBuffer, offset, (long)transactionSize);
                    }
                    executor.submit(() -> this.writeToOutputStream(outputStream, outputBuffer));
                }
                executor.shutdown();
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (IOException | InterruptedException e) {
                Logger.error((Throwable)e);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void serialize(LedStream<? extends Transaction> ledStream) {
        long elementCount = 0L;
        try (OutputStream fos = this.destination;){
            LedHeader header = new LedHeader();
            header.elementCount(-1L).elementSize(ledStream.transactionSize());
            fos.write(header.toByteArray());
            try (SnappyOutputStream outputStream = new SnappyOutputStream(fos);){
                int transactionSize = ledStream.transactionSize();
                byte[] outputBuffer = new byte[1024 * transactionSize];
                int offset = 0;
                while (ledStream.hasNext()) {
                    Transaction schema = (Transaction)ledStream.next();
                    MemoryUtils.memcpy(schema.address(), schema.baseOffset(), outputBuffer, (long)offset, (long)transactionSize);
                    if ((offset += transactionSize) == outputBuffer.length) {
                        this.writeToOutputStream(outputStream, outputBuffer);
                        offset = 0;
                    }
                    ++elementCount;
                }
                if (offset > 0) {
                    this.writeToOutputStream(outputStream, outputBuffer, 0, offset);
                }
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        if (this.destinationFile != null) {
            this.overrideHeader(elementCount, ledStream.transactionSize());
        }
    }

    private void overrideHeader(long elementCount, int transactionSize) {
        try (RandomAccessFile raFile = new RandomAccessFile(this.destinationFile, "rw");){
            raFile.writeLong(elementCount);
            raFile.writeInt(transactionSize);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void writeToOutputStream(SnappyOutputStream outputStream, byte[] outputBuffer) {
        this.writeToOutputStream(outputStream, outputBuffer, 0, outputBuffer.length);
    }

    private void writeToOutputStream(SnappyOutputStream outputStream, byte[] outputBuffer, int offset, int size) {
        try {
            outputStream.write(outputBuffer, offset, size);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

