/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.LedHeader;
import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocatorFactory;
import io.intino.alexandria.led.allocators.stack.StackAllocator;
import io.intino.alexandria.led.allocators.stack.StackAllocators;
import io.intino.alexandria.led.leds.IndexedLed;
import io.intino.alexandria.led.util.MemoryUtils;
import io.intino.alexandria.logger.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xerial.snappy.SnappyInputStream;

public class LedReader {
    private final InputStream source;
    private final File sourceFile;

    public LedReader(File file) {
        this.source = LedReader.inputStreamOf(file);
        this.sourceFile = file;
    }

    public LedReader(InputStream source) {
        this.source = source;
        this.sourceFile = null;
    }

    public int size() {
        int n;
        if (this.sourceFile == null) {
            return -1;
        }
        RandomAccessFile raFile = new RandomAccessFile(this.sourceFile, "r");
        try {
            n = (int)raFile.readLong();
        }
        catch (Throwable throwable) {
            try {
                try {
                    raFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return -1;
            }
        }
        raFile.close();
        return n;
    }

    public <S extends Transaction> Led<S> readAll(TransactionFactory<S> factory) {
        return this.readAll(this.getDefaultAllocatorFactory(), factory);
    }

    public <S extends Transaction> Led<S> readAll(IndexedAllocatorFactory<S> allocatorFactory, TransactionFactory<S> factory) {
        IndexedLed<S> indexedLed;
        LedHeader header = LedHeader.from(this.source);
        SnappyInputStream inputStream = new SnappyInputStream(this.source);
        try {
            IndexedAllocator<S> allocator = allocatorFactory.create((InputStream)inputStream, header.elementCount(), header.elementSize(), factory);
            indexedLed = new IndexedLed<S>(allocator);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return null;
            }
        }
        inputStream.close();
        return indexedLed;
    }

    public <S extends Transaction> LedStream<S> read(TransactionFactory<S> factory) {
        try {
            LedHeader header = LedHeader.from(this.source);
            return this.allocate(new SnappyInputStream(this.source), factory, header.elementSize());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private <S extends Transaction> LedStream<S> allocate(SnappyInputStream inputStream, TransactionFactory<S> factory, int transactionSize) {
        return new ReaderLedStream<S>((InputStream)inputStream, factory, transactionSize);
    }

    private static InputStream inputStreamOf(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private <S extends Transaction> IndexedAllocatorFactory<S> getDefaultAllocatorFactory() {
        return (inputStream, elementCount, elementSize, factory) -> {
            if (elementCount >= 0L && elementCount * (long)elementSize < Integer.MAX_VALUE) {
                return IndexedAllocatorFactory.newManagedIndexedAllocator(inputStream, elementCount, elementSize, factory);
            }
            return IndexedAllocatorFactory.newArrayAllocator(inputStream, elementCount, elementSize, factory);
        };
    }

    private static class ReaderLedStream<T extends Transaction>
    implements LedStream<T> {
        private static final int INPUT_BUFFER_MIN_SIZE = 1024;
        private final InputStream inputStream;
        private final int transactionSize;
        private final TransactionFactory<T> provider;
        private final Iterator<T> iterator;

        public ReaderLedStream(InputStream inputStream, TransactionFactory<T> provider, int transactionSize) {
            this.inputStream = inputStream;
            this.transactionSize = transactionSize;
            this.provider = provider;
            this.iterator = this.stream().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return (T)((Transaction)this.iterator.next());
        }

        public synchronized Stream<T> stream() {
            return Stream.generate(() -> this.read(this.inputStream)).takeWhile(inputBuffer -> this.checkInputBuffer((ByteBuffer)inputBuffer, this.inputStream)).flatMap(this::allocateAll);
        }

        @Override
        public int transactionSize() {
            return this.transactionSize;
        }

        private boolean checkInputBuffer(ByteBuffer inputBuffer, InputStream inputStream) {
            if (inputBuffer != null) {
                return true;
            }
            this.closeInputStream(inputStream);
            return false;
        }

        private synchronized void closeInputStream(InputStream inputStream) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }

        private Stream<T> allocateAll(ByteBuffer bytes) {
            StackAllocator allocator = StackAllocators.newManaged(this.transactionSize, bytes, this.provider);
            return IntStream.range(0, bytes.remaining() / this.transactionSize).sorted().parallel().mapToObj(index -> allocator.malloc());
        }

        private ByteBuffer read(InputStream inputStream) {
            try {
                if (inputStream == null || inputStream.available() <= 0) {
                    return null;
                }
                byte[] inputBuffer = new byte[1024 * this.transactionSize];
                int bytesRead = inputStream.read(inputBuffer);
                if (bytesRead < 0) {
                    return null;
                }
                ByteBuffer buffer = MemoryUtils.allocBuffer(bytesRead);
                buffer.put(inputBuffer, 0, bytesRead);
                buffer.clear();
                return buffer;
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                return null;
            }
        }

        @Override
        public void close() throws Exception {
            this.inputStream.close();
        }
    }
}

