/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionAllocator;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import io.intino.alexandria.led.allocators.indexed.ListAllocator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class LedBuilder<S extends Transaction> {
    private final TransactionAllocator<S> allocator;
    private final int transactionSize;

    public LedBuilder(int transactionSize, TransactionFactory<S> factory) {
        this.transactionSize = transactionSize;
        this.allocator = this.createBuilderDefaultAllocator(transactionSize, factory);
    }

    public LedBuilder(TransactionAllocator<S> allocator, int transactionSize) {
        this.allocator = Objects.requireNonNull(allocator);
        this.transactionSize = transactionSize;
    }

    public S createTransaction() {
        return this.allocator.malloc();
    }

    public Led<S> build() {
        return new Led<S>(){

            @Override
            public long size() {
                return LedBuilder.this.allocator.size();
            }

            @Override
            public int transactionSize() {
                return LedBuilder.this.transactionSize;
            }

            @Override
            public S transaction(int index) {
                if (LedBuilder.this.allocator instanceof IndexedAllocator) {
                    return ((IndexedAllocator)LedBuilder.this.allocator).malloc(index);
                }
                throw new UnsupportedOperationException("Allocator is not indexed");
            }

            @Override
            public Iterator<S> iterator() {
                return this.stream().iterator();
            }

            @Override
            public List<S> elements() {
                return this.stream().collect(Collectors.toList());
            }

            private Stream<S> stream() {
                if (LedBuilder.this.allocator instanceof IndexedAllocator) {
                    IndexedAllocator theAllocator = (IndexedAllocator)LedBuilder.this.allocator;
                    return IntStream.range(0, (int)this.size()).mapToObj(theAllocator::malloc);
                }
                LedBuilder.this.allocator.clear();
                return IntStream.range(0, (int)this.size()).mapToObj(i -> LedBuilder.this.allocator.malloc());
            }
        };
    }

    private TransactionAllocator<S> createBuilderDefaultAllocator(int transactionSize, TransactionFactory<S> factory) {
        return new ListAllocator<S>(1000L, transactionSize, factory);
    }
}

