/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.jms;

import io.intino.alexandria.jms.JmsConsumer;
import io.intino.alexandria.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQSession;

public class DurableTopicConsumer
extends JmsConsumer {
    protected List<Consumer<Message>> listeners;
    private final String subscriberId;

    public DurableTopicConsumer(Session session, String topic, String subscriberId) throws JMSException {
        super(session, (Destination)session.createTopic(topic));
        this.subscriberId = subscriberId;
        this.listeners = new ArrayList<Consumer<Message>>();
        try {
            this.consumer = session.createDurableSubscriber((Topic)this.destination, subscriberId, null, true);
        }
        catch (JMSException ex) {
            Logger.error((Throwable)ex);
        }
    }

    public String subscriberId() {
        return this.subscriberId;
    }

    public void destroy() {
        try {
            if (this.consumer == null) {
                return;
            }
            this.consumer.close();
            if (this.subscriberId != null && !((ActiveMQSession)this.session).isClosed()) {
                this.session.unsubscribe(this.subscriberId);
            }
        }
        catch (InvalidDestinationException invalidDestinationException) {
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
        }
    }
}

