/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ingestion;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventWriter;
import io.intino.alexandria.ingestion.SessionHandler;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public class EventSession {
    private final Map<Fingerprint, EventWriter<Event>> writers = new ConcurrentHashMap<Fingerprint, EventWriter<Event>>();
    private final SessionHandler.Provider provider;
    private final int autoFlush;
    private final AtomicInteger count = new AtomicInteger();

    public EventSession(SessionHandler.Provider provider) {
        this(provider, 1000000);
    }

    public EventSession(SessionHandler.Provider provider, int autoFlush) {
        this.provider = provider;
        this.autoFlush = autoFlush;
    }

    public void put(String tank, String source, Timetag timetag, Event.Format format, Event ... events) throws IOException {
        this.put(tank, source, timetag, format, Arrays.stream(events));
        if (this.count.addAndGet(events.length) >= this.autoFlush) {
            this.flush();
        }
    }

    public void put(String tank, String source, Timetag timetag, Event.Format format, Stream<Event> eventStream) throws IOException {
        this.put(this.writerOf(tank, source, timetag, format), eventStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Iterator<EventWriter<Event>> iterator = this.writers.values().iterator();
        while (iterator.hasNext()) {
            EventWriter<Event> w;
            EventWriter<Event> eventWriter = w = iterator.next();
            synchronized (eventWriter) {
                try {
                    w.flush();
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                }
            }
        }
        this.count.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            Iterator<EventWriter<Event>> iterator = this.writers.values().iterator();
            while (iterator.hasNext()) {
                EventWriter<Event> w;
                EventWriter<Event> eventWriter = w = iterator.next();
                synchronized (eventWriter) {
                    w.close();
                }
            }
            return;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(EventWriter<Event> writer, Stream<Event> events) {
        EventWriter<Event> eventWriter = writer;
        synchronized (eventWriter) {
            events.forEach(e -> this.write(writer, (Event)e));
        }
    }

    private void write(EventWriter<Event> writer, Event event) {
        try {
            writer.write(event);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private EventWriter<Event> writerOf(String tank, String source, Timetag timetag, Event.Format format) throws IOException {
        return this.writerOf(Fingerprint.of((String)tank, (String)EventSession.withOutParameters(source), (Timetag)timetag, (Event.Format)format));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventWriter<Event> writerOf(Fingerprint fingerprint) throws IOException {
        Map<Fingerprint, EventWriter<Event>> map = this.writers;
        synchronized (map) {
            if (!this.writers.containsKey(fingerprint)) {
                this.writers.put(fingerprint, this.createWriter(fingerprint));
            }
            return this.writers.get(fingerprint);
        }
    }

    private EventWriter<Event> createWriter(Fingerprint fingerprint) throws IOException {
        return EventWriter.of((Event.Format)fingerprint.format(), (File)this.provider.file(fingerprint.name(), fingerprint.format()));
    }

    private static String withOutParameters(String ss) {
        return ss.contains("?") ? ss.substring(0, ss.indexOf("?")) : ss;
    }
}

