/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.server;

import io.intino.alexandria.Context;
import io.intino.alexandria.http.server.AlexandriaHttpManager;

public class AlexandriaHttpContext
extends Context {
    private final AlexandriaHttpManager<?> manager;

    public AlexandriaHttpContext(AlexandriaHttpManager<?> manager) {
        this.manager = manager;
        this.initialize();
    }

    public String domain() {
        return this.manager.domain();
    }

    public String baseUrl() {
        return this.manager.baseUrl();
    }

    public String requestUrl() {
        return this.manager.baseUrl() + this.manager.request().raw().getPathInfo();
    }

    public String realIp() {
        return this.manager.realIp();
    }

    public String queryParameter(String name) {
        return this.manager.fromQuery(name);
    }

    public String header(String name) {
        return this.manager.fromHeader(name);
    }

    public void header(String name, String value) {
        this.manager.response().header(name, value);
    }

    public AlexandriaHttpManager<?> manager() {
        return this.manager;
    }

    private void initialize() {
        this.put("domain", this.domain());
        this.put("baseUrl", this.baseUrl());
        this.put("requestUrl", this.requestUrl());
        this.put("realIp", this.realIp());
    }
}

