/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.pushservice;

import io.intino.alexandria.http.pushservice.Client;
import io.intino.alexandria.http.pushservice.Session;
import io.intino.alexandria.http.pushservice.SessionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class PushService<S extends Session<C>, C extends Client> {
    private final Map<String, List<Consumer<String>>> messageListeners = new HashMap<String, List<Consumer<String>>>();
    protected final Queue<Function<C, Boolean>> openConnectionListeners = new ConcurrentLinkedQueue<Function<C, Boolean>>();
    protected final Map<String, List<Consumer<C>>> closeConnectionListeners = new HashMap<String, List<Consumer<C>>>();
    protected final Map<String, List<Consumer<C>>> closeScheduledConnectionListeners = new HashMap<String, List<Consumer<C>>>();
    protected final SessionManager<S, C> sessionManager = new SessionManager();

    public void onOpen(Function<C, Boolean> consumer) {
        this.openConnectionListeners.add(consumer);
    }

    public Connection onMessage(String clientId, Consumer<String> consumer) {
        this.messageListeners.putIfAbsent(clientId, new ArrayList());
        this.messageListeners.get(clientId).add(consumer);
        return () -> {
            Map<String, List<Consumer<String>>> map = this.messageListeners;
            synchronized (map) {
                if (!this.messageListeners.containsKey(clientId)) {
                    return;
                }
                this.messageListeners.get(clientId).remove(consumer);
            }
        };
    }

    public ClosedConnection onClose(String clientId) {
        return consumer -> {
            this.closeConnectionListeners.putIfAbsent(clientId, new ArrayList());
            this.closeConnectionListeners.get(clientId).add(consumer);
        };
    }

    public ClosedConnection onCloseScheduled(String clientId) {
        return consumer -> {
            this.closeScheduledConnectionListeners.putIfAbsent(clientId, new ArrayList());
            this.closeScheduledConnectionListeners.get(clientId).add(consumer);
        };
    }

    public abstract S createSession(String var1);

    public abstract C createClient(org.eclipse.jetty.websocket.api.Session var1);

    public synchronized void onOpen(C client) {
        this.registerClient(client);
        this.sessionManager.linkToThread(client);
        ArrayList acceptListeners = new ArrayList();
        this.openConnectionListeners.forEach(listener -> {
            Boolean acceptClient = (Boolean)listener.apply(client);
            if (acceptClient.booleanValue()) {
                acceptListeners.add(listener);
            }
        });
        acceptListeners.forEach(this.openConnectionListeners::remove);
        this.sessionManager.unlinkFromThread();
    }

    public void onMessage(C client, String message) {
        this.messageListeners.putIfAbsent(client.id(), new ArrayList());
        this.messageListeners.get(client.id()).forEach(listener -> listener.accept(message));
    }

    public void onClose(C client) {
        this.sessionManager.unRegister(client);
        this.messageListeners.remove(client.id());
        if (this.closeConnectionListeners.containsKey(client.id())) {
            this.closeConnectionListeners.get(client.id()).forEach(clientConsumer -> clientConsumer.accept(client));
        }
        this.closeConnectionListeners.remove(client.id());
    }

    public void onCloseScheduled(C client) {
        if (this.closeScheduledConnectionListeners.containsKey(client.id())) {
            this.closeScheduledConnectionListeners.get(client.id()).forEach(clientConsumer -> clientConsumer.accept(client));
        }
        this.closeScheduledConnectionListeners.remove(client.id());
    }

    public void pushBroadcast(String message) {
        this.sessionManager.sessions().forEach(session -> session.clients().forEach(client -> client.send(message)));
    }

    public void pushToSession(S session, String message) {
        session.send(message);
    }

    public void pushToClient(C client, String message) {
        client.send(message);
    }

    public void linkToThread(C client) {
        this.sessionManager.linkToThread(client);
    }

    public void unlinkFromThread() {
        this.sessionManager.unlinkFromThread();
    }

    public void unRegister(C client) {
        this.sessionManager.unRegister(client);
    }

    public boolean existsSession(String id) {
        return this.sessionManager.session(id) != null;
    }

    public S session(String id) {
        this.registerSession(id);
        return this.sessionManager.session(id);
    }

    public C client(String id) {
        return this.sessionManager.client(id);
    }

    public C currentClient() {
        return this.sessionManager.currentClient();
    }

    private void registerSession(String sessionId) {
        if (this.sessionManager.session(sessionId) != null) {
            return;
        }
        this.sessionManager.register(this.createSession(sessionId));
    }

    private void registerClient(C client) {
        this.registerSession(client.sessionId());
        this.sessionManager.register(client);
    }

    public static interface Connection {
        public void unRegister();
    }

    public static interface ClosedConnection<C extends Client> {
        public void execute(Consumer<C> var1);
    }

    public static interface MessageListener {
        public void onMessage(String var1);
    }

    public static interface OpenConnectionListener<C extends Client> {
        public void onOpen(C var1);
    }
}

